/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.formatter.casechanger;

import java.util.Objects;
import org.jabref.logic.cleanup.Formatter;
import org.jabref.logic.l10n.Localization;

public class UnprotectTermsFormatter
extends Formatter {
    @Override
    public String format(String text) {
        Objects.requireNonNull(text);
        if (text.isEmpty()) {
            return text;
        }
        StringBuilder result = new StringBuilder();
        int level = 0;
        int index = 0;
        do {
            char charAtIndex;
            if ((charAtIndex = text.charAt(index)) == '{') {
                ++level;
                continue;
            }
            if (charAtIndex == '}') {
                --level;
                continue;
            }
            result.append(charAtIndex);
        } while (++index < text.length() && level >= 0);
        if (level != 0) {
            return text;
        }
        return result.toString();
    }

    @Override
    public String getDescription() {
        return Localization.lang("Removes all balanced {} braces around words.", new Object[0]);
    }

    @Override
    public String getExampleInput() {
        return "{In} {CDMA}";
    }

    @Override
    public String getName() {
        return Localization.lang("Unprotect terms", new Object[0]);
    }

    @Override
    public String getKey() {
        return "unprotect_terms";
    }
}

