/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.formatter.casechanger;

import java.util.List;
import java.util.Objects;
import org.jabref.logic.cleanup.Formatter;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.protectedterms.ProtectedTermsLoader;
import org.jabref.logic.util.strings.StringLengthComparator;

public class ProtectTermsFormatter
extends Formatter {
    private final ProtectedTermsLoader protectedTermsLoader;

    public ProtectTermsFormatter(ProtectedTermsLoader protectedTermsLoader) {
        this.protectedTermsLoader = protectedTermsLoader;
    }

    private String format(String text, List<String> listOfWords) {
        String result = text;
        listOfWords.sort(new StringLengthComparator());
        for (String listOfWord : listOfWords) {
            result = result.replaceAll("(^|[- /\\[(}\"])" + listOfWord + "($|[^a-zA-Z}])", "$1\\{" + listOfWord + "\\}$2");
        }
        result = result.replace("{}", "");
        return result;
    }

    @Override
    public String format(String text) {
        Objects.requireNonNull(text);
        if (text.isEmpty()) {
            return text;
        }
        return this.format(text, this.protectedTermsLoader.getProtectedTerms());
    }

    @Override
    public String getDescription() {
        return Localization.lang("Adds {} brackets around acronyms, month names and countries to preserve their case.", new Object[0]);
    }

    @Override
    public String getExampleInput() {
        return "In CDMA";
    }

    @Override
    public String getName() {
        return Localization.lang("Protect terms", new Object[0]);
    }

    @Override
    public String getKey() {
        return "protect_terms";
    }
}

