/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.formatter.bibtexfields;

import java.util.ArrayList;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jabref.logic.cleanup.Formatter;
import org.jabref.logic.l10n.Localization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexFormatter
extends Formatter {
    public static final String KEY = "regex";
    private static final Logger LOGGER = LoggerFactory.getLogger(RegexFormatter.class);
    private static final Pattern ESCAPED_OPENING_CURLY_BRACE = Pattern.compile("\\\\\\{");
    private static final Pattern ESCAPED_CLOSING_CURLY_BRACE = Pattern.compile("\\\\\\}");
    private static final Pattern ENCLOSED_IN_CURLY_BRACES = Pattern.compile("\\{.*?}");
    private static final String REGEX_CAPTURING_GROUP = "regex";
    private static final String REPLACEMENT_CAPTURING_GROUP = "replacement";
    private static final Pattern CONSTRUCTOR_ARGUMENT = Pattern.compile("^\\(\"(?<regex>.*?)\" *?, *?\"(?<replacement>.*)\"\\)$");
    private static final String PLACEHOLDER_FOR_PROTECTED_GROUP = Character.toString('\u0a14');
    private static final String PLACEHOLDER_FOR_OPENING_CURLY_BRACE = Character.toString('\u0a15');
    private static final String PLACEHOLDER_FOR_CLOSING_CURLY_BRACE = Character.toString('\u0a16');
    private final String regex;
    private final String replacement;

    public RegexFormatter(String input) {
        Objects.requireNonNull(input);
        input = input.trim();
        Matcher constructorArgument = CONSTRUCTOR_ARGUMENT.matcher(input);
        if (constructorArgument.matches()) {
            this.regex = constructorArgument.group("regex");
            this.replacement = constructorArgument.group(REPLACEMENT_CAPTURING_GROUP);
        } else {
            this.regex = null;
            this.replacement = null;
            LOGGER.warn("RegexFormatter could not parse the input: {}", (Object)input);
        }
    }

    @Override
    public String getName() {
        return Localization.lang("regular expression", new Object[0]);
    }

    @Override
    public String getKey() {
        return "regex";
    }

    private String replaceHonoringProtectedGroups(String input) {
        Matcher matcher = ENCLOSED_IN_CURLY_BRACES.matcher(input);
        ArrayList<String> replaced = new ArrayList<String>();
        while (matcher.find()) {
            replaced.add(matcher.group());
        }
        String workingString = matcher.replaceAll(PLACEHOLDER_FOR_PROTECTED_GROUP);
        try {
            workingString = workingString.replaceAll(this.regex, this.replacement);
        }
        catch (PatternSyntaxException e) {
            LOGGER.warn("There is a syntax error in the regular expression \"{}\" used by the regex modifier", (Object)this.regex, (Object)e);
            return input;
        }
        for (String r : replaced) {
            workingString = workingString.replaceFirst(PLACEHOLDER_FOR_PROTECTED_GROUP, r);
        }
        return workingString;
    }

    @Override
    public String format(String input) {
        Objects.requireNonNull(input);
        if (this.regex == null || this.replacement == null) {
            return input;
        }
        Matcher escapedOpeningCurlyBrace = ESCAPED_OPENING_CURLY_BRACE.matcher(input);
        String inputWithPlaceholder = escapedOpeningCurlyBrace.replaceAll(PLACEHOLDER_FOR_OPENING_CURLY_BRACE);
        Matcher escapedClosingCurlyBrace = ESCAPED_CLOSING_CURLY_BRACE.matcher(inputWithPlaceholder);
        inputWithPlaceholder = escapedClosingCurlyBrace.replaceAll(PLACEHOLDER_FOR_CLOSING_CURLY_BRACE);
        String regexMatchesReplaced = this.replaceHonoringProtectedGroups(inputWithPlaceholder);
        return regexMatchesReplaced.replaceAll(PLACEHOLDER_FOR_OPENING_CURLY_BRACE, "\\\\{").replaceAll(PLACEHOLDER_FOR_CLOSING_CURLY_BRACE, "\\\\}");
    }

    @Override
    public String getDescription() {
        return Localization.lang("Add a regular expression for the key pattern.", new Object[0]);
    }

    @Override
    public String getExampleInput() {
        return "Please replace the spaces";
    }
}

