/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.formatter.bibtexfields;

import java.text.Normalizer;
import org.jabref.logic.cleanup.Formatter;

public class NormalizeUnicodeFormatter
extends Formatter {
    @Override
    public String getName() {
        return "Normalize Unicode";
    }

    @Override
    public String getKey() {
        return "NORMALIZE_UNICODE";
    }

    @Override
    public String getDescription() {
        return "Normalize Unicode characters in BibTeX fields.";
    }

    @Override
    public String getExampleInput() {
        return "H\u00e9ll\u00f4 W\u00f6rld";
    }

    @Override
    public String format(String value) {
        String normalizedValue = Normalizer.normalize(value, Normalizer.Form.NFC);
        return normalizedValue;
    }
}

