/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.externalfiles;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.jabref.logic.util.io.FileUtil;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.LinkedFile;
import org.jabref.preferences.FilePreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkedFileHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(LinkedFileHandler.class);
    private final BibDatabaseContext databaseContext;
    private final FilePreferences filePreferences;
    private final BibEntry entry;
    private final LinkedFile fileEntry;

    public LinkedFileHandler(LinkedFile fileEntry, BibEntry entry, BibDatabaseContext databaseContext, FilePreferences filePreferences) {
        this.fileEntry = fileEntry;
        this.entry = entry;
        this.databaseContext = Objects.requireNonNull(databaseContext);
        this.filePreferences = Objects.requireNonNull(filePreferences);
    }

    public boolean moveToDefaultDirectory() throws IOException {
        Path targetPath;
        Optional<Path> targetDirectory = this.databaseContext.getFirstExistingFileDir(this.filePreferences);
        if (targetDirectory.isEmpty()) {
            return false;
        }
        Optional<Path> oldFile = this.fileEntry.findIn(this.databaseContext, this.filePreferences);
        if (oldFile.isEmpty()) {
            return false;
        }
        String targetDirectoryName = "";
        if (!this.filePreferences.getFileDirectoryPattern().isEmpty()) {
            targetDirectoryName = FileUtil.createDirNameFromPattern(this.databaseContext.getDatabase(), this.entry, this.filePreferences.getFileDirectoryPattern());
        }
        if (Files.exists(targetPath = targetDirectory.get().resolve(targetDirectoryName).resolve(oldFile.get().getFileName()), new LinkOption[0])) {
            LOGGER.debug("The file {} would have been moved to {}. However, there exists already a file with that name so we do nothing.", (Object)oldFile.get(), (Object)targetPath);
            return false;
        }
        Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
        Files.move(oldFile.get(), targetPath, new CopyOption[0]);
        this.fileEntry.setLink(FileUtil.relativize(targetPath, this.databaseContext, this.filePreferences).toString());
        return true;
    }

    public boolean renameToSuggestedName() throws IOException {
        return this.renameToName(this.getSuggestedFileName(), false);
    }

    public boolean renameToName(String targetFileName, boolean overwriteExistingFile) throws IOException {
        boolean pathsDifferOnlyByCase;
        Optional<Path> oldFile = this.fileEntry.findIn(this.databaseContext, this.filePreferences);
        if (oldFile.isEmpty()) {
            return false;
        }
        Path oldPath = oldFile.get();
        Path newPath = oldPath.resolveSibling(targetFileName);
        String expandedOldFilePath = oldPath.toString();
        boolean bl = pathsDifferOnlyByCase = newPath.toString().equalsIgnoreCase(expandedOldFilePath) && !newPath.toString().equals(expandedOldFilePath);
        if (Files.exists(newPath, new LinkOption[0]) && !pathsDifferOnlyByCase && !overwriteExistingFile) {
            LOGGER.debug("The file {} would have been moved to {}. However, there exists already a file with that name so we do nothing.", (Object)oldPath, (Object)newPath);
            return false;
        }
        if (Files.exists(newPath, new LinkOption[0]) && !pathsDifferOnlyByCase && overwriteExistingFile) {
            Files.createDirectories(newPath.getParent(), new FileAttribute[0]);
            LOGGER.debug("Overwriting existing file {}", (Object)newPath);
            Files.move(oldPath, newPath, StandardCopyOption.REPLACE_EXISTING);
        } else {
            Files.createDirectories(newPath.getParent(), new FileAttribute[0]);
            Files.move(oldPath, newPath, new CopyOption[0]);
        }
        this.fileEntry.setLink(FileUtil.relativize(newPath, this.databaseContext, this.filePreferences).toString());
        return true;
    }

    public String getSuggestedFileName() {
        String oldFileName = this.fileEntry.getLink();
        String extension = FileUtil.getFileExtension(oldFileName).orElse(this.fileEntry.getFileType());
        return this.getSuggestedFileName(extension);
    }

    public String getSuggestedFileName(String extension) {
        String targetFileName = FileUtil.createFileNameFromPattern(this.databaseContext.getDatabase(), this.entry, this.filePreferences.getFileNamePattern()).trim() + "." + extension;
        return FileUtil.getValidFileName(targetFileName);
    }

    public Optional<Path> findExistingFile(LinkedFile linkedFile, BibEntry entry, String targetFileName) {
        Path targetFilePath = linkedFile.findIn(this.databaseContext, this.filePreferences).get().getParent().resolve(targetFileName);
        Path oldFilePath = linkedFile.findIn(this.databaseContext, this.filePreferences).get();
        Optional<Path> matchedByDiffCase = Optional.empty();
        try (Stream<Path> stream = Files.list(oldFilePath.getParent());){
            matchedByDiffCase = stream.filter(name -> name.toString().equalsIgnoreCase(targetFilePath.toString())).findFirst();
        }
        catch (IOException e) {
            LOGGER.error("Could not get the list of files in target directory", (Throwable)e);
        }
        return matchedByDiffCase;
    }
}

