/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.exporter;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.font.Standard14Fonts;
import org.jabref.logic.exporter.Exporter;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.StandardFileType;
import org.jabref.logic.xmp.XmpPreferences;
import org.jabref.logic.xmp.XmpUtilWriter;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmpPdfExporter
extends Exporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmpPdfExporter.class);
    private final XmpPreferences xmpPreferences;

    public XmpPdfExporter(XmpPreferences xmpPreferences) {
        super("pdf", Localization.lang("XMP-annotated PDF", new Object[0]), StandardFileType.PDF);
        this.xmpPreferences = xmpPreferences;
    }

    @Override
    public void export(BibDatabaseContext databaseContext, Path pdfFile, List<BibEntry> entries) throws Exception {
        Objects.requireNonNull(databaseContext);
        Objects.requireNonNull(pdfFile);
        Objects.requireNonNull(entries);
        Path filePath = pdfFile.toAbsolutePath();
        if (!Files.exists(filePath, new LinkOption[0])) {
            try (PDDocument document = new PDDocument();){
                PDPage page = new PDPage();
                document.addPage(page);
                try (PDPageContentStream contentStream = new PDPageContentStream(document, page);){
                    contentStream.beginText();
                    contentStream.newLineAtOffset(25.0f, 500.0f);
                    contentStream.setFont((PDFont)new PDType1Font(Standard14Fonts.FontName.HELVETICA), 12.0f);
                    contentStream.showText("This PDF was created by JabRef. It demonstrates the embedding of XMP data in PDF files. Please open the file metadata view of your PDF viewer to see the attached files. Note that the normal usage is to embed the BibTeX data in an existing PDF.");
                    contentStream.endText();
                }
                document.save(filePath.toString());
            }
            catch (IOException e) {
                LOGGER.error("Could not create PDF file", (Throwable)e);
            }
            new XmpUtilWriter(this.xmpPreferences).writeXmp(pdfFile, entries, databaseContext.getDatabase());
        }
    }
}

