/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.exporter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.jabref.logic.citationkeypattern.AbstractCitationKeyPatterns;
import org.jabref.logic.citationkeypattern.CitationKeyPattern;
import org.jabref.logic.citationkeypattern.GlobalCitationKeyPatterns;
import org.jabref.logic.exporter.GroupSerializer;
import org.jabref.logic.util.OS;
import org.jabref.model.entry.BibEntryType;
import org.jabref.model.entry.field.BibField;
import org.jabref.model.entry.field.FieldFactory;
import org.jabref.model.entry.types.EntryType;
import org.jabref.model.groups.GroupTreeNode;
import org.jabref.model.metadata.ContentSelector;
import org.jabref.model.metadata.MetaData;
import org.jabref.model.strings.StringUtil;

public class MetaDataSerializer {
    private MetaDataSerializer() {
    }

    public static Map<String, String> getSerializedStringMap(MetaData metaData, GlobalCitationKeyPatterns globalCiteKeyPatterns) {
        HashMap<String, List<String>> stringyMetaData = new HashMap<String, List<String>>();
        metaData.getSaveOrder().ifPresent(saveOrderConfig -> stringyMetaData.put("saveOrderConfig", saveOrderConfig.getAsStringList()));
        metaData.getSaveActions().ifPresent(saveActions -> stringyMetaData.put("saveActions", saveActions.getAsStringList(OS.NEWLINE)));
        if (metaData.isProtected()) {
            stringyMetaData.put("protectedFlag", Collections.singletonList("true"));
        }
        stringyMetaData.putAll(MetaDataSerializer.serializeCiteKeyPatterns(metaData, globalCiteKeyPatterns));
        metaData.getMode().ifPresent(mode -> stringyMetaData.put("databaseType", Collections.singletonList(mode.getAsString())));
        metaData.getDefaultFileDirectory().ifPresent(path -> stringyMetaData.put("fileDirectory", Collections.singletonList(path.trim())));
        metaData.getUserFileDirectories().forEach((user, path) -> stringyMetaData.put("fileDirectory-" + user, Collections.singletonList(path.trim())));
        metaData.getLatexFileDirectories().forEach((user, path) -> stringyMetaData.put("fileDirectoryLatex-" + user, Collections.singletonList(path.toString().trim())));
        metaData.getVersionDBStructure().ifPresent(versionDBStructure -> stringyMetaData.put("VersionDBStructure", Collections.singletonList(versionDBStructure.trim())));
        for (ContentSelector selector : metaData.getContentSelectorsSorted()) {
            stringyMetaData.put("selector_" + selector.getField().getName(), selector.getValues());
        }
        Map<String, String> serializedMetaData = MetaDataSerializer.serializeMetaData(stringyMetaData);
        metaData.getGroups().filter(root -> root.getNumberOfChildren() > 0).ifPresent(root -> serializedMetaData.put("grouping", MetaDataSerializer.serializeGroups(root)));
        Map<String, List<String>> unknownMetaData = metaData.getUnknownMetaData();
        for (Map.Entry<String, List<String>> entry : unknownMetaData.entrySet()) {
            StringJoiner value = new StringJoiner(MetaData.SEPARATOR_STRING + OS.NEWLINE, OS.NEWLINE, MetaData.SEPARATOR_STRING + OS.NEWLINE);
            for (String line : entry.getValue()) {
                value.add(line.replace(MetaData.SEPARATOR_STRING, "\\" + MetaData.SEPARATOR_STRING));
            }
            serializedMetaData.put(entry.getKey(), value.toString());
        }
        return serializedMetaData;
    }

    private static Map<String, String> serializeMetaData(Map<String, List<String>> stringyMetaData) {
        TreeMap<String, String> serializedMetaData = new TreeMap<String, String>();
        for (Map.Entry<String, List<String>> metaItem : stringyMetaData.entrySet()) {
            List<String> itemList = metaItem.getValue();
            if (itemList.isEmpty()) continue;
            boolean isSaveActions = metaItem.getKey().equals("saveActions");
            StringJoiner joiner = new StringJoiner(MetaData.SEPARATOR_STRING, "", MetaData.SEPARATOR_STRING);
            boolean lastWasSaveActionsEnablement = false;
            for (String dataItem : itemList) {
                Object string = lastWasSaveActionsEnablement ? OS.NEWLINE : "";
                string = (String)string + StringUtil.quote(dataItem, MetaData.SEPARATOR_STRING, '\\');
                lastWasSaveActionsEnablement = isSaveActions && ("enabled".equals(dataItem) || "disabled".equals(dataItem));
                joiner.add((CharSequence)string);
            }
            String serializedItem = joiner.toString();
            if (serializedItem.isEmpty()) continue;
            serializedMetaData.put(metaItem.getKey(), serializedItem);
        }
        return serializedMetaData;
    }

    private static Map<String, List<String>> serializeCiteKeyPatterns(MetaData metaData, GlobalCitationKeyPatterns globalCitationKeyPatterns) {
        HashMap<String, List<String>> stringyPattern = new HashMap<String, List<String>>();
        AbstractCitationKeyPatterns citationKeyPattern = metaData.getCiteKeyPatterns(globalCitationKeyPatterns);
        for (EntryType key : citationKeyPattern.getAllKeys()) {
            if (citationKeyPattern.isDefaultValue(key)) continue;
            ArrayList<String> data = new ArrayList<String>();
            data.add(citationKeyPattern.getValue(key).stringRepresentation());
            String metaDataKey = "keypattern_" + key.getName();
            stringyPattern.put(metaDataKey, data);
        }
        if (citationKeyPattern.getDefaultValue() != null && !citationKeyPattern.getDefaultValue().equals(CitationKeyPattern.NULL_CITATION_KEY_PATTERN)) {
            ArrayList<String> data = new ArrayList<String>();
            data.add(citationKeyPattern.getDefaultValue().stringRepresentation());
            stringyPattern.put("keypatterndefault", data);
        }
        return stringyPattern;
    }

    private static String serializeGroups(GroupTreeNode root) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(OS.NEWLINE);
        for (String groupNode : new GroupSerializer().serializeTree(root)) {
            stringBuilder.append(StringUtil.quote(groupNode, MetaData.SEPARATOR_STRING, '\\'));
            stringBuilder.append(MetaData.SEPARATOR_STRING);
            stringBuilder.append(OS.NEWLINE);
        }
        return stringBuilder.toString();
    }

    public static String serializeCustomEntryTypes(BibEntryType entryType) {
        StringBuilder builder = new StringBuilder();
        builder.append("jabref-entrytype: ");
        builder.append(entryType.getType().getName());
        builder.append(": req[");
        builder.append(FieldFactory.serializeOrFieldsList(entryType.getRequiredFields()));
        builder.append("] opt[");
        builder.append(FieldFactory.serializeFieldsList(entryType.getOptionalFields().stream().map(BibField::field).collect(Collectors.toList())));
        builder.append("]");
        return builder.toString();
    }
}

