/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.exporter;

import java.io.IOException;
import java.io.Writer;
import org.jabref.model.strings.StringUtil;

public class BibWriter {
    private final String newLineSeparator;
    private final Writer writer;
    private boolean precedingNewLineRequired = false;
    private boolean somethingWasWritten = false;
    private boolean lastWriteWasNewline = false;

    public BibWriter(Writer writer, String newLineSeparator) {
        this.writer = writer;
        this.newLineSeparator = newLineSeparator;
    }

    public void write(String string) throws IOException {
        if (this.precedingNewLineRequired) {
            this.writer.write(this.newLineSeparator);
            this.precedingNewLineRequired = false;
        }
        string = StringUtil.unifyLineBreaks(string, this.newLineSeparator);
        this.writer.write(string);
        this.lastWriteWasNewline = string.endsWith(this.newLineSeparator);
        this.somethingWasWritten = true;
    }

    public void writeLine(String string) throws IOException {
        this.write(string);
        this.finishLine();
    }

    public void finishLine() throws IOException {
        if (!this.lastWriteWasNewline) {
            this.write(this.newLineSeparator);
        }
    }

    public void finishBlock() throws IOException {
        if (!this.somethingWasWritten) {
            return;
        }
        if (!this.lastWriteWasNewline) {
            this.finishLine();
        }
        this.somethingWasWritten = false;
        this.precedingNewLineRequired = true;
    }
}

