/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.cleanup;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jabref.logic.cleanup.CleanupJob;
import org.jabref.logic.preferences.TimestampPreferences;
import org.jabref.model.FieldChange;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.Date;
import org.jabref.model.entry.event.EntriesEventSource;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.StandardField;

public class TimeStampToModificationDate
implements CleanupJob {
    private final Field timeStampField;

    public TimeStampToModificationDate(TimestampPreferences timestampPreferences) {
        this.timeStampField = timestampPreferences.getTimestampField();
    }

    private Optional<String> formatTimeStamp(String timeStamp) {
        Optional<Date> parsedDate = Date.parse(timeStamp);
        if (parsedDate.isEmpty()) {
            return Optional.empty();
        }
        Date date = parsedDate.get();
        int year = date.getYear().orElse(1);
        int month = this.getMonth(date);
        int day = date.getDay().orElse(1);
        LocalDateTime localDateTime = LocalDateTime.of(year, month, day, 0, 0);
        localDateTime.truncatedTo(ChronoUnit.SECONDS);
        return Optional.of(localDateTime.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
    }

    private int getMonth(Date date) {
        if (date.getMonth().isPresent()) {
            return date.getMonth().get().getNumber();
        }
        return 1;
    }

    @Override
    public List<FieldChange> cleanup(BibEntry entry) {
        if (entry.getField(this.timeStampField).isPresent()) {
            Optional<String> formattedTimeStamp = this.formatTimeStamp(entry.getField(this.timeStampField).get());
            if (formattedTimeStamp.isEmpty()) {
                return Collections.emptyList();
            }
            entry.clearField(this.timeStampField, EntriesEventSource.CLEANUP_TIMESTAMP);
            ArrayList<FieldChange> changeList = new ArrayList<FieldChange>();
            changeList.add(new FieldChange(entry, StandardField.TIMESTAMP, formattedTimeStamp.get(), ""));
            entry.setField(StandardField.MODIFICATIONDATE, formattedTimeStamp.get(), EntriesEventSource.CLEANUP_TIMESTAMP);
            FieldChange changeTo = new FieldChange(entry, StandardField.MODIFICATIONDATE, entry.getField(StandardField.MODIFICATIONDATE).orElse(""), formattedTimeStamp.get());
            changeList.add(changeTo);
            return changeList;
        }
        return Collections.emptyList();
    }
}

