/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.cleanup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jabref.logic.bibtex.FieldPreferences;
import org.jabref.logic.cleanup.CleanupJob;
import org.jabref.logic.formatter.bibtexfields.NormalizeWhitespaceFormatter;
import org.jabref.model.FieldChange;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.FieldFactory;

public class NormalizeWhitespacesCleanup
implements CleanupJob {
    private static final Collection<Field> NO_TEXT_FIELDS = FieldFactory.getNotTextFields();
    private final NormalizeWhitespaceFormatter formatter;

    public NormalizeWhitespacesCleanup(FieldPreferences fieldPreferences) {
        this.formatter = new NormalizeWhitespaceFormatter(fieldPreferences);
    }

    @Override
    public List<FieldChange> cleanup(BibEntry entry) {
        ArrayList<FieldChange> changes = new ArrayList<FieldChange>();
        for (Field field : entry.getFields()) {
            String oldValue;
            String newValue;
            if (NO_TEXT_FIELDS.contains(field) || (newValue = this.formatter.format(oldValue = entry.getField(field).orElseThrow(), field)).equals(oldValue)) continue;
            entry.setField(field, newValue).ifPresent(changes::add);
        }
        return changes;
    }
}

