/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.cleanup;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jabref.logic.bibtex.FileFieldWriter;
import org.jabref.logic.cleanup.CleanupJob;
import org.jabref.model.FieldChange;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.LinkedFile;
import org.jabref.model.entry.field.StandardField;

public class FileLinksCleanup
implements CleanupJob {
    @Override
    public List<FieldChange> cleanup(BibEntry entry) {
        Optional<String> oldValue = entry.getField(StandardField.FILE);
        if (!oldValue.isPresent()) {
            return Collections.emptyList();
        }
        List<LinkedFile> fileList = entry.getFiles();
        String newValue = FileFieldWriter.getStringRepresentation(fileList);
        if (!oldValue.get().equals(newValue)) {
            entry.setField(StandardField.FILE, newValue);
            FieldChange change = new FieldChange(entry, StandardField.FILE, oldValue.get(), newValue);
            return Collections.singletonList(change);
        }
        return Collections.emptyList();
    }
}

