/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.cleanup;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.jabref.logic.cleanup.CleanupJob;
import org.jabref.logic.cleanup.Formatter;
import org.jabref.model.FieldChange;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.event.EntriesEventSource;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.FieldFactory;
import org.jabref.model.entry.field.InternalField;

public class FieldFormatterCleanup
implements CleanupJob {
    private final Field field;
    private final Formatter formatter;

    public FieldFormatterCleanup(Field field, Formatter formatter) {
        this.field = field;
        this.formatter = formatter;
    }

    @Override
    public List<FieldChange> cleanup(BibEntry entry) {
        if (InternalField.INTERNAL_ALL_FIELD == this.field) {
            return this.cleanupAllFields(entry);
        }
        if (InternalField.INTERNAL_ALL_TEXT_FIELDS_FIELD == this.field) {
            return this.cleanupAllTextFields(entry);
        }
        return this.cleanupSingleField(this.field, entry);
    }

    private List<FieldChange> cleanupSingleField(Field fieldKey, BibEntry entry) {
        if (!entry.hasField(fieldKey)) {
            return List.of();
        }
        String oldValue = entry.getField(fieldKey).orElse(null);
        String newValue = this.formatter.format(oldValue);
        if (newValue.equals(oldValue)) {
            return List.of();
        }
        if (newValue.isEmpty()) {
            entry.clearField(fieldKey);
            newValue = null;
        } else {
            entry.setField(fieldKey, newValue, EntriesEventSource.SAVE_ACTION);
        }
        FieldChange change = new FieldChange(entry, fieldKey, oldValue, newValue);
        return List.of(change);
    }

    private List<FieldChange> cleanupAllFields(BibEntry entry) {
        ArrayList<FieldChange> fieldChanges = new ArrayList<FieldChange>();
        for (Field fieldKey : entry.getFields()) {
            if (fieldKey.equals(InternalField.KEY_FIELD)) continue;
            fieldChanges.addAll(this.cleanupSingleField(fieldKey, entry));
        }
        return fieldChanges;
    }

    private List<FieldChange> cleanupAllTextFields(BibEntry entry) {
        ArrayList<FieldChange> fieldChanges = new ArrayList<FieldChange>();
        HashSet<Field> fields = new HashSet<Field>(entry.getFields());
        FieldFactory.getNotTextFields().forEach(fields::remove);
        for (Field fieldKey : fields) {
            if (fieldKey.equals(InternalField.KEY_FIELD)) continue;
            fieldChanges.addAll(this.cleanupSingleField(fieldKey, entry));
        }
        return fieldChanges;
    }

    public Field getField() {
        return this.field;
    }

    public Formatter getFormatter() {
        return this.formatter;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof FieldFormatterCleanup) {
            FieldFormatterCleanup that = (FieldFormatterCleanup)obj;
            return Objects.equals(this.field, that.field) && Objects.equals(this.formatter, that.formatter);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.field, this.formatter);
    }

    public String toString() {
        return String.valueOf(this.field) + ": " + this.formatter.getName();
    }
}

