/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.cleanup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.jabref.logic.cleanup.CleanupJob;
import org.jabref.model.FieldChange;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.identifier.ArXivIdentifier;

public class EprintCleanup
implements CleanupJob {
    @Override
    public List<FieldChange> cleanup(BibEntry entry) {
        ArrayList<FieldChange> changes = new ArrayList<FieldChange>();
        for (Field field : Arrays.asList(StandardField.URL, StandardField.JOURNAL, StandardField.JOURNALTITLE, StandardField.NOTE)) {
            Optional arXivIdentifier = entry.getField(field).flatMap(ArXivIdentifier::parse);
            if (!arXivIdentifier.isPresent()) continue;
            entry.setField(StandardField.EPRINT, ((ArXivIdentifier)arXivIdentifier.get()).getNormalized()).ifPresent(changes::add);
            entry.setField(StandardField.EPRINTTYPE, "arxiv").ifPresent(changes::add);
            ((ArXivIdentifier)arXivIdentifier.get()).getClassification().ifPresent(classification -> entry.setField(StandardField.EPRINTCLASS, (String)classification).ifPresent(changes::add));
            entry.clearField(field).ifPresent(changes::add);
            if (!field.equals(StandardField.URL)) continue;
            entry.clearField(StandardField.URLDATE).ifPresent(changes::add);
        }
        return changes;
    }
}

