/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.cleanup;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.jabref.logic.cleanup.CleanupJob;
import org.jabref.logic.cleanup.FieldFormatterCleanup;
import org.jabref.logic.formatter.bibtexfields.ClearFormatter;
import org.jabref.model.FieldChange;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.field.UnknownField;
import org.jabref.model.entry.identifier.ArXivIdentifier;
import org.jabref.model.entry.identifier.DOI;

public class DoiCleanup
implements CleanupJob {
    private static final List<Field> FIELDS = Arrays.asList(StandardField.NOTE, StandardField.URL, StandardField.EPRINT, new UnknownField("ee"));

    @Override
    public List<FieldChange> cleanup(BibEntry entry) {
        ArrayList<FieldChange> changes;
        block5: {
            block4: {
                changes = new ArrayList<FieldChange>();
                if (!entry.hasField(StandardField.DOI)) break block4;
                String doiFieldValue = entry.getField(StandardField.DOI).orElse(null);
                String decodeDoiFieldValue = "";
                decodeDoiFieldValue = URLDecoder.decode(doiFieldValue, StandardCharsets.UTF_8);
                Optional<DOI> doi = DOI.parse(doiFieldValue = decodeDoiFieldValue);
                if (!doi.isPresent()) break block5;
                String newValue = doi.get().getDOI();
                if (!doiFieldValue.equals(newValue)) {
                    entry.setField(StandardField.DOI, newValue);
                    FieldChange change = new FieldChange(entry, StandardField.DOI, doiFieldValue, newValue);
                    changes.add(change);
                }
                for (Field field : FIELDS) {
                    entry.getField(field).flatMap(DOI::parse).ifPresent(unused -> this.removeFieldValue(entry, field, changes));
                }
                break block5;
            }
            for (Field field : FIELDS) {
                Optional<String> fieldContentOpt = entry.getField(field);
                Optional doi = fieldContentOpt.flatMap(DOI::parse);
                if (doi.isPresent()) {
                    Optional<FieldChange> change = entry.setField(StandardField.DOI, ((DOI)doi.get()).getDOI());
                    change.ifPresent(changes::add);
                    this.removeFieldValue(entry, field, changes);
                }
                if (StandardField.EPRINT != field) continue;
                fieldContentOpt.flatMap(ArXivIdentifier::parse).flatMap(ArXivIdentifier::inferDOI).ifPresent(inferredDoi -> {
                    Optional<FieldChange> change = entry.setField(StandardField.DOI, inferredDoi.getDOI());
                    change.ifPresent(changes::add);
                });
            }
        }
        return changes;
    }

    private void removeFieldValue(BibEntry entry, Field field, List<FieldChange> changes) {
        FieldFormatterCleanup eraser = new FieldFormatterCleanup(field, new ClearFormatter());
        changes.addAll(eraser.cleanup(entry));
    }
}

