/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.citationkeypattern;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.PatternSyntaxException;
import org.jabref.logic.citationkeypattern.AbstractCitationKeyPatterns;
import org.jabref.logic.citationkeypattern.BracketedPattern;
import org.jabref.logic.citationkeypattern.CitationKeyPattern;
import org.jabref.logic.citationkeypattern.CitationKeyPatternPreferences;
import org.jabref.model.FieldChange;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.types.EntryType;
import org.jabref.model.strings.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CitationKeyGenerator
extends BracketedPattern {
    public static final String APPENDIX_CHARACTERS = "abcdefghijklmnopqrstuvwxyz";
    public static final String DEFAULT_UNWANTED_CHARACTERS = "-`\u02b9:!;?^";
    private static final Logger LOGGER = LoggerFactory.getLogger(CitationKeyGenerator.class);
    private static final List<Character> DISALLOWED_CHARACTERS = Arrays.asList(Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf(','), Character.valueOf('='), Character.valueOf('\\'), Character.valueOf('\"'), Character.valueOf('#'), Character.valueOf('%'), Character.valueOf('~'), Character.valueOf('\''));
    private final AbstractCitationKeyPatterns citeKeyPattern;
    private final BibDatabase database;
    private final CitationKeyPatternPreferences citationKeyPatternPreferences;
    private final String unwantedCharacters;

    public CitationKeyGenerator(BibDatabaseContext bibDatabaseContext, CitationKeyPatternPreferences citationKeyPatternPreferences) {
        this(bibDatabaseContext.getMetaData().getCiteKeyPatterns(citationKeyPatternPreferences.getKeyPatterns()), bibDatabaseContext.getDatabase(), citationKeyPatternPreferences);
    }

    public CitationKeyGenerator(AbstractCitationKeyPatterns citeKeyPattern, BibDatabase database, CitationKeyPatternPreferences citationKeyPatternPreferences) {
        this.citeKeyPattern = Objects.requireNonNull(citeKeyPattern);
        this.database = Objects.requireNonNull(database);
        this.citationKeyPatternPreferences = Objects.requireNonNull(citationKeyPatternPreferences);
        this.unwantedCharacters = citationKeyPatternPreferences.getUnwantedCharacters();
    }

    private static String getAppendix(int number) {
        if (number >= APPENDIX_CHARACTERS.length()) {
            int lastChar = number % APPENDIX_CHARACTERS.length();
            return CitationKeyGenerator.getAppendix(number / APPENDIX_CHARACTERS.length() - 1) + APPENDIX_CHARACTERS.charAt(lastChar);
        }
        return APPENDIX_CHARACTERS.substring(number, number + 1);
    }

    public static String removeDefaultUnwantedCharacters(String key) {
        return CitationKeyGenerator.removeUnwantedCharacters(key, DEFAULT_UNWANTED_CHARACTERS);
    }

    public static String removeUnwantedCharacters(String key, String unwantedCharacters) {
        String newKey = key.chars().filter(c -> unwantedCharacters.indexOf(c) == -1).filter(c -> !DISALLOWED_CHARACTERS.contains(Character.valueOf((char)c))).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
        return StringUtil.replaceSpecialCharacters(newKey);
    }

    public static String cleanKey(String key, String unwantedCharacters) {
        return CitationKeyGenerator.removeUnwantedCharacters(key, unwantedCharacters).replaceAll("\\s", "");
    }

    public String generateKey(BibEntry entry) {
        Objects.requireNonNull(entry);
        String currentKey = entry.getCitationKey().orElse(null);
        String newKey = this.createCitationKeyFromPattern(entry);
        newKey = this.replaceWithRegex(newKey);
        newKey = this.appendLettersToKey(newKey, currentKey);
        return CitationKeyGenerator.cleanKey(newKey, this.unwantedCharacters);
    }

    private String appendLettersToKey(String key, String oldKey) {
        boolean alwaysAddLetter;
        long occurrences = this.database.getNumberOfCitationKeyOccurrences((String)key);
        if (occurrences > 0L && Objects.equals(oldKey, key)) {
            --occurrences;
        }
        boolean bl = alwaysAddLetter = this.citationKeyPatternPreferences.getKeySuffix() == CitationKeyPatternPreferences.KeySuffix.ALWAYS;
        if (alwaysAddLetter || occurrences != 0L) {
            String moddedKey;
            boolean firstLetterA = this.citationKeyPatternPreferences.getKeySuffix() == CitationKeyPatternPreferences.KeySuffix.SECOND_WITH_A;
            int number = !alwaysAddLetter && !firstLetterA ? 1 : 0;
            do {
                moddedKey = (String)key + CitationKeyGenerator.getAppendix(number);
                ++number;
                occurrences = this.database.getNumberOfCitationKeyOccurrences(moddedKey);
                if (!Objects.equals(oldKey, moddedKey)) continue;
                --occurrences;
            } while (occurrences > 0L);
            key = moddedKey;
        }
        return key;
    }

    private String replaceWithRegex(String key) {
        String regex = this.citationKeyPatternPreferences.getKeyPatternRegex();
        if (regex != null && !regex.trim().isEmpty()) {
            String replacement = this.citationKeyPatternPreferences.getKeyPatternReplacement();
            try {
                key = key.replaceAll(regex, replacement);
            }
            catch (PatternSyntaxException e) {
                LOGGER.warn("There is a syntax error in the regular expression \"{}\" used to generate a citation key", (Object)regex, (Object)e);
            }
        }
        return key;
    }

    private String createCitationKeyFromPattern(BibEntry entry) {
        EntryType entryType = entry.getType();
        CitationKeyPattern citationKeyPattern = this.citeKeyPattern.getValue(entryType);
        if (citationKeyPattern == null || CitationKeyPattern.NULL_CITATION_KEY_PATTERN.equals(citationKeyPattern)) {
            return "";
        }
        return CitationKeyGenerator.expandBrackets(citationKeyPattern.stringRepresentation(), this.expandBracketContent(entry));
    }

    private Function<String, String> expandBracketContent(BibEntry entry) {
        Character keywordDelimiter = this.citationKeyPatternPreferences.getKeywordDelimiter();
        return bracket -> {
            List<String> fieldParts = CitationKeyGenerator.parseFieldAndModifiers(bracket);
            String expandedPattern = CitationKeyGenerator.removeUnwantedCharacters(CitationKeyGenerator.getFieldValue(entry, fieldParts.getFirst(), keywordDelimiter, this.database), this.unwantedCharacters);
            if (fieldParts.size() > 1) {
                expandedPattern = CitationKeyGenerator.applyModifiers(expandedPattern, fieldParts, 1, this.expandBracketContent(entry));
            }
            return CitationKeyGenerator.cleanKey(expandedPattern, this.unwantedCharacters);
        };
    }

    public Optional<FieldChange> generateAndSetKey(BibEntry entry) {
        String newKey = this.generateKey(entry);
        return entry.setCitationKey(newKey);
    }
}

