/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.bst.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BstTextPrefixer {
    private static final Logger LOGGER = LoggerFactory.getLogger(BstTextPrefixer.class);

    private BstTextPrefixer() {
    }

    public static String textPrefix(int inNumOfChars, String toPrefix) {
        int numOfChars = inNumOfChars;
        StringBuilder sb = new StringBuilder();
        char[] cs = toPrefix.toCharArray();
        int n = cs.length;
        int i = 0;
        int braceLevel = 0;
        while (i < n && numOfChars > 0) {
            char c = cs[i];
            ++i;
            if (c == '{') {
                if (++braceLevel != 1 || i >= n || cs[i] != '\\') continue;
                ++i;
                while (i < n && braceLevel > 0) {
                    if (cs[i] == '}') {
                        --braceLevel;
                    } else if (cs[i] == '{') {
                        ++braceLevel;
                    }
                    ++i;
                }
                --numOfChars;
                continue;
            }
            if (c == '}') {
                if (braceLevel > 0) {
                    --braceLevel;
                    continue;
                }
                LOGGER.warn("Unbalanced brace in string for purify$: {}", (Object)toPrefix);
                continue;
            }
            --numOfChars;
        }
        sb.append(toPrefix, 0, i);
        while (braceLevel > 0) {
            sb.append('}');
            --braceLevel;
        }
        return sb.toString();
    }
}

