/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.bst;

import com.google.common.annotations.VisibleForTesting;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.jabref.logic.bst.BstEntry;
import org.jabref.logic.bst.BstVM;
import org.jabref.logic.bst.BstVMContext;
import org.jabref.logic.bst.BstVMException;
import org.jabref.logic.bst.BstVMVisitor;
import org.jabref.logic.bst.util.BstCaseChanger;
import org.jabref.logic.bst.util.BstNameFormatter;
import org.jabref.logic.bst.util.BstPurifier;
import org.jabref.logic.bst.util.BstTextPrefixer;
import org.jabref.logic.bst.util.BstWidthCalculator;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.Author;
import org.jabref.model.entry.AuthorList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BstFunctions {
    private static final Logger LOGGER = LoggerFactory.getLogger(BstFunctions.class);
    private static final Pattern ADD_PERIOD_PATTERN = Pattern.compile("([^.?!}\\s])(}|\\s)*$");
    private final Map<String, String> strings;
    private final Map<String, Integer> integers;
    private final Map<String, BstFunction> functions;
    private final String preamble;
    private final Deque<Object> stack;
    private final StringBuilder bbl;
    private int bstWarning = 0;

    public BstFunctions(BstVMContext bstVMContext, StringBuilder bbl) {
        this.strings = bstVMContext.strings();
        this.integers = bstVMContext.integers();
        this.functions = bstVMContext.functions();
        this.preamble = Optional.ofNullable(bstVMContext.bibDatabase()).flatMap(BibDatabase::getPreamble).orElse("");
        this.stack = bstVMContext.stack();
        this.bbl = bbl;
    }

    protected Map<String, BstFunction> getBuiltInFunctions() {
        HashMap<String, BstFunction> builtInFunctions = new HashMap<String, BstFunction>();
        builtInFunctions.put(">", this::bstIsGreaterThan);
        builtInFunctions.put("<", this::bstIsLowerThan);
        builtInFunctions.put("=", this::bstEquals);
        builtInFunctions.put("+", this::bstAdd);
        builtInFunctions.put("-", this::bstSubtract);
        builtInFunctions.put("*", this::bstConcat);
        builtInFunctions.put(":=", new BstAssignFunction());
        builtInFunctions.put("add.period$", this::bstAddPeriod);
        builtInFunctions.put("call.type$", new BstCallTypeFunction());
        builtInFunctions.put("change.case$", this::bstChangeCase);
        builtInFunctions.put("chr.to.int$", this::bstChrToInt);
        builtInFunctions.put("cite$", new BstCiteFunction());
        builtInFunctions.put("duplicate$", this::bstDuplicate);
        builtInFunctions.put("empty$", this::bstEmpty);
        builtInFunctions.put("format.name$", this::bstFormatName);
        builtInFunctions.put("if$", this::bstIf);
        builtInFunctions.put("int.to.chr$", this::bstIntToChr);
        builtInFunctions.put("int.to.str$", this::bstIntToStr);
        builtInFunctions.put("missing$", this::bstMissing);
        builtInFunctions.put("newline$", this::bstNewLine);
        builtInFunctions.put("num.names$", this::bstNumNames);
        builtInFunctions.put("pop$", this::bstPop);
        builtInFunctions.put("preamble$", this::bstPreamble);
        builtInFunctions.put("purify$", this::bstPurify);
        builtInFunctions.put("quote$", this::bstQuote);
        builtInFunctions.put("skip$", this::bstSkip);
        builtInFunctions.put("stack$", this::bstStack);
        builtInFunctions.put("substring$", this::bstSubstring);
        builtInFunctions.put("swap$", this::bstSwap);
        builtInFunctions.put("text.length$", this::bstTextLength);
        builtInFunctions.put("text.prefix$", this::bstTextPrefix);
        builtInFunctions.put("top$", this::bstTop);
        builtInFunctions.put("type$", new BstTypeFunction());
        builtInFunctions.put("warning$", this::bstWarning);
        builtInFunctions.put("while$", this::bstWhile);
        builtInFunctions.put("width$", this::bstWidth);
        builtInFunctions.put("write$", this::bstWrite);
        return builtInFunctions;
    }

    private void bstIsGreaterThan(BstVMVisitor visitor, ParserRuleContext ctx) {
        if (this.stack.size() < 2) {
            throw new BstVMException("Not enough operands on stack for operation > (line %d)".formatted(ctx.start.getLine()));
        }
        Object o2 = this.stack.pop();
        Object o1 = this.stack.pop();
        if (!(o1 instanceof Integer) || !(o2 instanceof Integer)) {
            throw new BstVMException("Can only compare two integers with >");
        }
        this.stack.push(((Integer)o1).compareTo((Integer)o2) > 0 ? BstVM.TRUE : BstVM.FALSE);
    }

    private void bstIsLowerThan(BstVMVisitor visitor, ParserRuleContext ctx) {
        if (this.stack.size() < 2) {
            throw new BstVMException("Not enough operands on stack for operation <");
        }
        Object o2 = this.stack.pop();
        Object o1 = this.stack.pop();
        if (!(o1 instanceof Integer) || !(o2 instanceof Integer)) {
            throw new BstVMException("Can only compare two integers with < (line %d)".formatted(ctx.start.getLine()));
        }
        this.stack.push(((Integer)o1).compareTo((Integer)o2) < 0 ? BstVM.TRUE : BstVM.FALSE);
    }

    private void bstEquals(BstVMVisitor visitor, ParserRuleContext ctx) {
        Object o2;
        if (this.stack.size() < 2) {
            throw new BstVMException("Not enough operands on stack for operation = (line %d)".formatted(ctx.start.getLine()));
        }
        Object o1 = this.stack.pop();
        if (o1 == null ^ (o2 = this.stack.pop()) == null) {
            this.stack.push(BstVM.FALSE);
            return;
        }
        if (o1 == null && o2 == null) {
            this.stack.push(BstVM.TRUE);
            return;
        }
        this.stack.push(o1.equals(o2) ? BstVM.TRUE : BstVM.FALSE);
    }

    private void bstAdd(BstVMVisitor visitor, ParserRuleContext ctx) {
        if (this.stack.size() < 2) {
            throw new BstVMException("Not enough operands on stack for operation + (line %d)".formatted(ctx.start.getLine()));
        }
        Object o2 = this.stack.pop();
        Object o1 = this.stack.pop();
        if (!(o1 instanceof Integer) || !(o2 instanceof Integer)) {
            throw new BstVMException("Can only compare two integers with + (line %d)".formatted(ctx.start.getLine()));
        }
        this.stack.push((Integer)o1 + (Integer)o2);
    }

    private void bstSubtract(BstVMVisitor visitor, ParserRuleContext ctx) {
        if (this.stack.size() < 2) {
            throw new BstVMException("Not enough operands on stack for operation - (line %d)".formatted(ctx.start.getLine()));
        }
        Object o2 = this.stack.pop();
        Object o1 = this.stack.pop();
        if (!(o1 instanceof Integer) || !(o2 instanceof Integer)) {
            throw new BstVMException("Can only subtract two integers with - (line %d)".formatted(ctx.start.getLine()));
        }
        this.stack.push((Integer)o1 - (Integer)o2);
    }

    private void bstConcat(BstVMVisitor visitor, ParserRuleContext ctx) {
        if (this.stack.size() < 2) {
            throw new BstVMException("Not enough operands on stack for operation * (line %d)".formatted(ctx.start.getLine()));
        }
        Object o2 = this.stack.pop();
        Object o1 = this.stack.pop();
        if (o1 == null) {
            o1 = "";
        }
        if (o2 == null) {
            o2 = "";
        }
        if (!(o1 instanceof String) || !(o2 instanceof String)) {
            LOGGER.error("o1: {} ({})", o1, o1.getClass());
            LOGGER.error("o2: {} ({})", o2, o2.getClass());
            throw new BstVMException("Can only concatenate two String with * (line %d)".formatted(ctx.start.getLine()));
        }
        this.stack.push(o1.toString() + String.valueOf(o2));
    }

    private void bstAddPeriod(BstVMVisitor visitor, ParserRuleContext ctx) {
        if (this.stack.isEmpty()) {
            throw new BstVMException("Not enough operands on stack for operation add.period$ (line %d)".formatted(ctx.start.getLine()));
        }
        Object o1 = this.stack.pop();
        if (!(o1 instanceof String)) {
            throw new BstVMException("Can only add a period to a string for add.period$ (line %d)".formatted(ctx.start.getLine()));
        }
        String s = (String)o1;
        Matcher m = ADD_PERIOD_PATTERN.matcher(s);
        if (m.find()) {
            StringBuilder sb = new StringBuilder();
            m.appendReplacement(sb, m.group(1));
            sb.append('.');
            String group2 = m.group(2);
            if (group2 != null) {
                sb.append(m.group(2));
            }
            this.stack.push(sb.toString());
        } else {
            this.stack.push(s);
        }
    }

    private void bstChangeCase(BstVMVisitor visitor, ParserRuleContext ctx) {
        String format;
        if (this.stack.size() < 2) {
            throw new BstVMException("Not enough operands on stack for operation change.case$ (line %d)".formatted(ctx.start.getLine()));
        }
        Object o1 = this.stack.pop();
        if (!(o1 instanceof String) || (format = (String)o1).length() != 1) {
            throw new BstVMException("A format string of length 1 is needed for change.case$ (line %d)".formatted(ctx.start.getLine()));
        }
        Object o2 = this.stack.pop();
        if (!(o2 instanceof String)) {
            throw new BstVMException("A string is needed as second parameter for change.case$ (line %d)".formatted(ctx.start.getLine()));
        }
        String toChange = (String)o2;
        this.stack.push(BstCaseChanger.changeCase(toChange, BstCaseChanger.FormatMode.of(format)));
    }

    private void bstChrToInt(BstVMVisitor visitor, ParserRuleContext ctx) {
        String s;
        block5: {
            block4: {
                if (this.stack.isEmpty()) {
                    throw new BstVMException("Not enough operands on stack for operation chr.to.int$ (line %d)".formatted(ctx.start.getLine()));
                }
                Object o1 = this.stack.pop();
                if (!(o1 instanceof String)) break block4;
                s = (String)o1;
                if (((String)o1).length() == 1) break block5;
            }
            throw new BstVMException("Can only perform chr.to.int$ on string with length 1 (line %d)".formatted(ctx.start.getLine()));
        }
        this.stack.push(s.charAt(0));
    }

    private void bstDuplicate(BstVMVisitor visitor, ParserRuleContext ctx) {
        if (this.stack.isEmpty()) {
            throw new BstVMException("Not enough operands on stack for operation duplicate$ (line %d)".formatted(ctx.start.getLine()));
        }
        Object o1 = this.stack.pop();
        this.stack.push(o1);
        this.stack.push(o1);
    }

    private void bstEmpty(BstVMVisitor visitor, ParserRuleContext ctx) {
        if (this.stack.isEmpty()) {
            throw new BstVMException("Not enough operands on stack for operation empty$ (line %d)".formatted(ctx.start.getLine()));
        }
        Object o1 = this.stack.pop();
        if (o1 == null) {
            LOGGER.trace("null is empty");
            this.stack.push(BstVM.TRUE);
            return;
        }
        if (!(o1 instanceof String)) {
            throw new BstVMException("Operand does not match function empty$ (line %d)".formatted(ctx.start.getLine()));
        }
        String s = (String)o1;
        boolean result = s.trim().isEmpty();
        LOGGER.trace("empty$({}) result: {}", (Object)s, (Object)result);
        this.stack.push(result ? BstVM.TRUE : BstVM.FALSE);
    }

    private void bstFormatName(BstVMVisitor visitor, ParserRuleContext ctx) {
        if (this.stack.size() < 3) {
            throw new BstVMException("Not enough operands on stack for operation format.name$ (line %d)".formatted(ctx.start.getLine()));
        }
        Object o1 = this.stack.pop();
        Object o2 = this.stack.pop();
        Object o3 = this.stack.pop();
        if (!(o1 instanceof String || o2 instanceof Integer || o3 instanceof String)) {
            this.stack.push("");
            return;
        }
        String format = (String)o1;
        Integer name = (Integer)o2;
        String names = (String)o3;
        if (names == null) {
            this.stack.push("");
        } else {
            AuthorList a = AuthorList.parse(names);
            if (name > a.getNumberOfAuthors()) {
                throw new BstVMException("Author Out of Bounds. Number %d invalid for %s (line %d)".formatted(name, names, ctx.start.getLine()));
            }
            Author author = a.getAuthor(name - 1);
            this.stack.push(BstNameFormatter.formatName(author, format));
        }
    }

    private void bstIf(BstVMVisitor visitor, ParserRuleContext ctx) {
        if (this.stack.size() < 3) {
            throw new BstVMException("Not enough operands on stack for if$ (line %d)".formatted(ctx.start.getLine()));
        }
        Object f1 = this.stack.pop();
        Object f2 = this.stack.pop();
        Object i = this.stack.pop();
        if (!(f1 instanceof BstVMVisitor.Identifier) && !(f1 instanceof ParseTree) && (f2 instanceof BstVMVisitor.Identifier || f2 instanceof ParseTree) && i instanceof Integer) {
            throw new BstVMException("Expecting two functions and an integer for if$ (line %d)".formatted(ctx.start.getLine()));
        }
        if ((Integer)i > 0) {
            this.callIdentifierOrTree(f2, visitor, ctx);
        } else {
            this.callIdentifierOrTree(f1, visitor, ctx);
        }
    }

    private void callIdentifierOrTree(Object f, BstVMVisitor visitor, ParserRuleContext ctx) {
        if (f instanceof ParseTree) {
            ParseTree tree = (ParseTree)f;
            visitor.visit(tree);
        } else if (f instanceof BstVMVisitor.Identifier) {
            BstVMVisitor.Identifier identifier = (BstVMVisitor.Identifier)f;
            visitor.resolveIdentifier(identifier.name(), ctx);
        } else {
            this.stack.push(f);
        }
    }

    private void bstIntToChr(BstVMVisitor visitor, ParserRuleContext ctx) {
        if (this.stack.isEmpty()) {
            throw new BstVMException("Not enough operands on stack for operation int.to.chr$ (line %d)".formatted(ctx.start.getLine()));
        }
        Object o1 = this.stack.pop();
        if (!(o1 instanceof Integer)) {
            throw new BstVMException("Can only perform operation int.to.chr$ on an Integer (line %d)".formatted(ctx.start.getLine()));
        }
        Integer i = (Integer)o1;
        this.stack.push(String.valueOf((char)i.intValue()));
    }

    private void bstIntToStr(BstVMVisitor visitor, ParserRuleContext ctx) {
        if (this.stack.isEmpty()) {
            throw new BstVMException("Not enough operands on stack for operation int.to.str$ (line %d)".formatted(ctx.start.getLine()));
        }
        Object o1 = this.stack.pop();
        if (!(o1 instanceof Integer)) {
            throw new BstVMException("Can only transform an integer to an string using int.to.str$ (line %d)".formatted(ctx.start.getLine()));
        }
        this.stack.push(o1.toString());
    }

    private void bstMissing(BstVMVisitor visitor, ParserRuleContext ctx) {
        if (this.stack.isEmpty()) {
            throw new BstVMException("Not enough operands on stack for operation missing$ (line %d)".formatted(ctx.start.getLine()));
        }
        Object o1 = this.stack.pop();
        if (o1 == null) {
            this.stack.push(BstVM.TRUE);
            return;
        }
        if (!(o1 instanceof String)) {
            LOGGER.warn("Not a string or missing field in operation missing$ (line %d)".formatted(ctx.start.getLine()));
            this.stack.push(BstVM.TRUE);
            return;
        }
        this.stack.push(BstVM.FALSE);
    }

    private void bstNewLine(BstVMVisitor visitor, ParserRuleContext ctx) {
        this.bbl.append('\n');
    }

    private void bstNumNames(BstVMVisitor visitor, ParserRuleContext ctx) {
        if (this.stack.isEmpty()) {
            throw new BstVMException("Not enough operands on stack for operation num.names$ (line %d)".formatted(ctx.start.getLine()));
        }
        Object o1 = this.stack.pop();
        if (!(o1 instanceof String)) {
            throw new BstVMException("Need a string at the top of the stack for num.names$ (line %d)".formatted(ctx.start.getLine()));
        }
        String s = (String)o1;
        this.stack.push(AuthorList.parse(s).getNumberOfAuthors());
    }

    private void bstPop(BstVMVisitor visitor, ParserRuleContext ctx) {
        this.stack.pop();
    }

    private void bstPreamble(BstVMVisitor visitor, ParserRuleContext ctx) {
        this.stack.push(this.preamble);
    }

    private void bstPurify(BstVMVisitor visitor, ParserRuleContext ctx) {
        if (this.stack.isEmpty()) {
            throw new BstVMException("Not enough operands on stack for operation purify$ (line %d)".formatted(ctx.start.getLine()));
        }
        Object o1 = this.stack.pop();
        if (!(o1 instanceof String)) {
            LOGGER.warn("A string is needed for purify$");
            this.stack.push("");
            return;
        }
        this.stack.push(BstPurifier.purify((String)o1));
    }

    private void bstQuote(BstVMVisitor visitor, ParserRuleContext ctx) {
        this.stack.push("\"");
    }

    private void bstSkip(BstVMVisitor visitor, ParserRuleContext ctx) {
    }

    private void bstStack(BstVMVisitor visitor, ParserRuleContext ctx) {
        while (!this.stack.isEmpty()) {
            LOGGER.debug("Stack entry {}", this.stack.pop());
        }
    }

    @VisibleForTesting
    void bstSubstring(BstVMVisitor visitor, ParserRuleContext ctx) {
        Integer start;
        Integer length;
        Object o3;
        block8: {
            block7: {
                if (this.stack.size() < 3) {
                    throw new BstVMException("Not enough operands on stack for operation substring$ (line %d)".formatted(ctx.start.getLine()));
                }
                Object o1 = this.stack.pop();
                Object o2 = this.stack.pop();
                o3 = this.stack.pop();
                if (!(o1 instanceof Integer)) break block7;
                length = (Integer)o1;
                if (!(o2 instanceof Integer)) break block7;
                start = (Integer)o2;
                if (o3 instanceof String) break block8;
            }
            throw new BstVMException("Expecting two integers and a string for substring$ (line %d)".formatted(ctx.start.getLine()));
        }
        String string = (String)o3;
        if (length > 0x3FFFFFFF) {
            length = 0x3FFFFFFF;
        }
        if (start > string.length() || start < -string.length()) {
            this.stack.push("");
            return;
        }
        if (start < 0) {
            int endOneBased = string.length() + start + 1;
            start = Math.max(1, endOneBased - length + 1);
            length = endOneBased - start + 1;
        }
        int zeroBasedStart = start - 1;
        int zeroBasedEnd = Math.min(zeroBasedStart + length, string.length());
        zeroBasedStart = Math.min(zeroBasedStart, zeroBasedEnd);
        String result = string.substring(zeroBasedStart, zeroBasedEnd);
        LOGGER.trace("substring$(s, start, len): ({}, {}, {})={}", new Object[]{string, start, length, result});
        this.stack.push(result);
    }

    private void bstSwap(BstVMVisitor visitor, ParserRuleContext ctx) {
        if (this.stack.size() < 2) {
            throw new BstVMException("Not enough operands on stack for operation swap$ (line %d)".formatted(ctx.start.getLine()));
        }
        Object f1 = this.stack.pop();
        Object f2 = this.stack.pop();
        this.stack.push(f1);
        this.stack.push(f2);
    }

    private void bstTextLength(BstVMVisitor visitor, ParserRuleContext ctx) {
        if (this.stack.isEmpty()) {
            throw new BstVMException("Not enough operands on stack for operation text.length$ (line %d)".formatted(ctx.start.getLine()));
        }
        Object o1 = this.stack.pop();
        if (!(o1 instanceof String)) {
            throw new BstVMException("Can only perform operation on a string text.length$ (line %d)".formatted(ctx.start.getLine()));
        }
        String s = (String)o1;
        char[] c = s.toCharArray();
        int result = 0;
        int i = 0;
        int n = s.length();
        int braceLevel = 0;
        while (i < n) {
            if (c[++i - 1] == '{') {
                if (++braceLevel != 1 || i >= n || c[i] != '\\') continue;
                ++i;
                while (i < n && braceLevel > 0) {
                    if (c[i] == '}') {
                        --braceLevel;
                    } else if (c[i] == '{') {
                        ++braceLevel;
                    }
                    ++i;
                }
                ++result;
                continue;
            }
            if (c[i - 1] == '}') {
                if (braceLevel <= 0) continue;
                --braceLevel;
                continue;
            }
            ++result;
        }
        this.stack.push(result);
    }

    private void bstTextPrefix(BstVMVisitor visitor, ParserRuleContext ctx) {
        if (this.stack.size() < 2) {
            throw new BstVMException("Not enough operands on stack for operation text.prefix$ (line %d)".formatted(ctx.start.getLine()));
        }
        Object o1 = this.stack.pop();
        if (!(o1 instanceof Integer)) {
            LOGGER.warn("An integer is needed as first parameter to text.prefix$ (line {})", (Object)ctx.start.getLine());
            this.stack.push("");
            return;
        }
        Object o2 = this.stack.pop();
        if (!(o2 instanceof String)) {
            LOGGER.warn("A string is needed as second parameter to text.prefix$ (line {})", (Object)ctx.start.getLine());
            this.stack.push("");
            return;
        }
        this.stack.push(BstTextPrefixer.textPrefix((Integer)o1, (String)o2));
    }

    private void bstTop(BstVMVisitor visitor, ParserRuleContext ctx) {
        LOGGER.debug("Stack entry {} (line {})", this.stack.pop(), (Object)ctx.start.getLine());
    }

    private void bstWarning(BstVMVisitor visitor, ParserRuleContext ctx) {
        LOGGER.warn("Warning (#{}): {}", (Object)this.bstWarning++, this.stack.pop());
    }

    private void bstWhile(BstVMVisitor visitor, ParserRuleContext ctx) {
        if (this.stack.size() < 2) {
            throw new BstVMException("Not enough operands on stack for operation while$ (line %d)".formatted(ctx.start.getLine()));
        }
        Object f2 = this.stack.pop();
        Object f1 = this.stack.pop();
        if (!(f1 instanceof BstVMVisitor.Identifier) && !(f1 instanceof ParseTree) && (f2 instanceof BstVMVisitor.Identifier || f2 instanceof ParseTree)) {
            throw new BstVMException("Expecting two functions for while$ (line %d)".formatted(ctx.start.getLine()));
        }
        while (true) {
            visitor.visit((ParseTree)f1);
            Object i = this.stack.pop();
            if (!(i instanceof Integer)) {
                throw new BstVMException("First parameter to while has to return an integer but was %s (line %d)".formatted(i.toString(), ctx.start.getLine()));
            }
            if ((Integer)i <= 0) break;
            visitor.visit((ParseTree)f2);
        }
    }

    private void bstWidth(BstVMVisitor visitor, ParserRuleContext ctx) {
        if (this.stack.isEmpty()) {
            throw new BstVMException("Not enough operands on stack for operation width$ (line %d)".formatted(ctx.start.getLine()));
        }
        Object o1 = this.stack.pop();
        if (!(o1 instanceof String)) {
            LOGGER.warn("A string is needed for width$");
            this.stack.push(0);
            return;
        }
        this.stack.push(BstWidthCalculator.width((String)o1));
    }

    private void bstWrite(BstVMVisitor visitor, ParserRuleContext ctx) {
        String s = (String)this.stack.pop();
        this.bbl.append(s);
    }

    @FunctionalInterface
    public static interface BstFunction {
        public void execute(BstVMVisitor var1, ParserRuleContext var2);

        default public void execute(BstVMVisitor visitor, ParserRuleContext ctx, BstEntry bstEntryContext) {
            this.execute(visitor, ctx);
        }
    }

    public class BstAssignFunction
    implements BstFunction {
        @Override
        public void execute(BstVMVisitor visitor, ParserRuleContext ctx) {
            this.execute(visitor, ctx, null);
        }

        @Override
        public void execute(BstVMVisitor visitor, ParserRuleContext ctx, BstEntry bstEntry) {
            if (BstFunctions.this.stack.size() < 2) {
                throw new BstVMException("Not enough operands on stack for operation := (line %d)".formatted(ctx.start.getLine()));
            }
            Object o1 = BstFunctions.this.stack.pop();
            Object o2 = BstFunctions.this.stack.pop();
            if (!(o1 instanceof BstVMVisitor.Identifier)) {
                throw new BstVMException("Invalid parameters (line %d)".formatted(ctx.start.getLine()));
            }
            BstVMVisitor.Identifier identifier = (BstVMVisitor.Identifier)o1;
            String name = identifier.name();
            if (o2 instanceof String) {
                String value = (String)o2;
                if (bstEntry != null && bstEntry.localStrings.containsKey(name)) {
                    bstEntry.localStrings.put(name, value);
                    return;
                }
                if (BstFunctions.this.strings.containsKey(name)) {
                    BstFunctions.this.strings.put(name, value);
                }
            } else if (o2 instanceof Integer) {
                Integer value = (Integer)o2;
                if (bstEntry != null && bstEntry.localIntegers.containsKey(name)) {
                    bstEntry.localIntegers.put(name, value);
                    return;
                }
                if (BstFunctions.this.integers.containsKey(name)) {
                    BstFunctions.this.integers.put(name, value);
                }
            } else {
                throw new BstVMException("Invalid parameters (line %d)".formatted(ctx.start.getLine()));
            }
        }
    }

    public class BstCallTypeFunction
    implements BstFunction {
        @Override
        public void execute(BstVMVisitor visitor, ParserRuleContext ctx) {
            throw new BstVMException("Call.type$ can only be called from within a context (ITERATE or REVERSE). (line %d)".formatted(ctx.start.getLine()));
        }

        @Override
        public void execute(BstVMVisitor visitor, ParserRuleContext ctx, BstEntry bstEntry) {
            if (bstEntry == null) {
                this.execute(visitor, ctx);
            } else {
                String entryType = bstEntry.entry.getType().getName();
                LOGGER.trace("Handling {}", (Object)entryType);
                if (!BstFunctions.this.functions.containsKey(entryType)) {
                    LOGGER.error("Function for {} not found ", (Object)entryType);
                    return;
                }
                BstFunctions.this.functions.get(entryType).execute(visitor, ctx, bstEntry);
            }
        }
    }

    public class BstCiteFunction
    implements BstFunction {
        @Override
        public void execute(BstVMVisitor visitor, ParserRuleContext ctx) {
            throw new BstVMException("Must have an entry to cite$ (line %d)".formatted(ctx.start.getLine()));
        }

        @Override
        public void execute(BstVMVisitor visitor, ParserRuleContext ctx, BstEntry bstEntryContext) {
            if (bstEntryContext == null) {
                this.execute(visitor, ctx);
                return;
            }
            BstFunctions.this.stack.push(bstEntryContext.entry.getCitationKey().orElse(null));
        }
    }

    public class BstTypeFunction
    implements BstFunction {
        @Override
        public void execute(BstVMVisitor visitor, ParserRuleContext ctx) {
            throw new BstVMException("type$ need a context (line %d)".formatted(ctx.start.getLine()));
        }

        @Override
        public void execute(BstVMVisitor visitor, ParserRuleContext ctx, BstEntry bstEntryContext) {
            if (bstEntryContext == null) {
                this.execute(visitor, ctx);
                return;
            }
            BstFunctions.this.stack.push(bstEntryContext.entry.getType().getName());
        }
    }
}

