/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.bibtex;

import java.util.Objects;
import java.util.Optional;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.BibEntryType;
import org.jabref.model.entry.BibEntryTypesManager;

public class TypedBibEntry {
    private final BibEntry entry;
    private final Optional<BibDatabase> database;
    private final BibDatabaseMode mode;

    public TypedBibEntry(BibEntry entry, BibDatabaseMode mode) {
        this.entry = Objects.requireNonNull(entry);
        this.database = Optional.empty();
        this.mode = mode;
    }

    public TypedBibEntry(BibEntry entry, BibDatabaseContext databaseContext) {
        this.entry = Objects.requireNonNull(entry);
        this.database = Optional.of(databaseContext.getDatabase());
        this.mode = Objects.requireNonNull(databaseContext).getMode();
    }

    public boolean hasAllRequiredFields(BibEntryTypesManager entryTypesManager) {
        Optional<BibEntryType> type = entryTypesManager.enrich(this.entry.getType(), this.mode);
        if (type.isPresent()) {
            return this.entry.allFieldsPresent(type.get().getRequiredFields(), this.database.orElse(null));
        }
        return true;
    }

    public String getTypeForDisplay() {
        return this.entry.getType().getDisplayName();
    }
}

