/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.http.server;

import com.airhacks.afterburner.injection.Injector;
import com.google.gson.Gson;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;
import java.util.Objects;
import org.jabref.http.dto.BibEntryDTO;
import org.jabref.logic.citationstyle.JabRefItemDataProvider;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.importer.fileformat.BibtexImporter;
import org.jabref.logic.util.io.BackupFileUtil;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.model.util.DummyFileUpdateMonitor;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="libraries/{id}")
public class LibraryResource {
    public static final Logger LOGGER = LoggerFactory.getLogger(LibraryResource.class);
    @Inject
    PreferencesService preferences;
    @Inject
    Gson gson;

    @GET
    @Produces(value={"application/json"})
    public String getJson(@PathParam(value="id") String id) {
        ParserResult parserResult = this.getParserResult(id);
        BibEntryTypesManager entryTypesManager = (BibEntryTypesManager)Injector.instantiateModelOrService(BibEntryTypesManager.class);
        List<BibEntryDTO> list = parserResult.getDatabase().getEntries().stream().peek(bibEntry -> bibEntry.getSharedBibEntryData().setSharedID(Objects.hash(bibEntry))).map(entry -> new BibEntryDTO((BibEntry)entry, parserResult.getDatabaseContext().getMode(), this.preferences.getFieldPreferences(), entryTypesManager)).toList();
        return this.gson.toJson(list);
    }

    @GET
    @Produces(value={"application/x-bibtex-library-csl+json"})
    public String getClsItemJson(@PathParam(value="id") String id) {
        ParserResult parserResult = this.getParserResult(id);
        JabRefItemDataProvider jabRefItemDataProvider = new JabRefItemDataProvider();
        jabRefItemDataProvider.setData(parserResult.getDatabaseContext(), new BibEntryTypesManager());
        return jabRefItemDataProvider.toJson();
    }

    private ParserResult getParserResult(String id) {
        ParserResult parserResult;
        java.nio.file.Path library = this.getLibraryPath(id);
        try {
            parserResult = new BibtexImporter(this.preferences.getImportFormatPreferences(), new DummyFileUpdateMonitor()).importDatabase(library);
        }
        catch (IOException e) {
            LOGGER.warn("Could not find open library file {}", (Object)library, (Object)e);
            throw new InternalServerErrorException("Could not parse library", (Throwable)e);
        }
        return parserResult;
    }

    @GET
    @Produces(value={"application/x-bibtex"})
    public Response getBibtex(@PathParam(value="id") String id) {
        String libraryAsString;
        java.nio.file.Path library = this.getLibraryPath(id);
        try {
            libraryAsString = Files.readString(library);
        }
        catch (IOException e) {
            LOGGER.error("Could not read library {}", (Object)library, (Object)e);
            throw new InternalServerErrorException("Could not read library " + String.valueOf(library), (Throwable)e);
        }
        return Response.ok().entity((Object)libraryAsString).build();
    }

    private java.nio.file.Path getLibraryPath(String id) {
        return this.preferences.getGuiPreferences().getLastFilesOpened().stream().filter(p -> (String.valueOf(p.getFileName()) + "-" + BackupFileUtil.getUniqueFilePrefix(p)).equals(id)).findAny().orElseThrow(NotFoundException::new);
    }
}

