/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.http.server;

import com.google.gson.Gson;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.List;
import org.jabref.logic.util.io.BackupFileUtil;
import org.jabref.preferences.PreferencesService;

@Path(value="libraries")
public class LibrariesResource {
    @Inject
    PreferencesService preferences;

    @GET
    @Produces(value={"application/json"})
    public String get() {
        List<String> fileNamesWithUniqueSuffix = this.preferences.getGuiPreferences().getLastFilesOpened().stream().map(p -> String.valueOf(p.getFileName()) + "-" + BackupFileUtil.getUniqueFilePrefix(p)).toList();
        return new Gson().toJson(fileNamesWithUniqueSuffix);
    }
}

