/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.util;

import com.tobiasdiez.easybind.Subscription;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.event.Event;
import javafx.event.EventType;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.TreeTableRow;
import javafx.scene.control.TreeTableView;
import javafx.scene.input.DragEvent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseDragEvent;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;
import org.jabref.gui.util.BindingsHelper;
import org.reactfx.util.TriConsumer;

public class ViewModelTreeTableRowFactory<S>
implements Callback<TreeTableView<S>, TreeTableRow<S>> {
    private BiConsumer<S, ? super MouseEvent> onMouseClickedEvent;
    private BiConsumer<S, ? super MouseEvent> onMousePressedEvent;
    private Consumer<TreeTableRow<S>> toCustomInitializer;
    private Function<S, ContextMenu> contextMenuFactory;
    private TriConsumer<TreeTableRow<S>, S, ? super MouseEvent> toOnDragDetected;
    private TriConsumer<TreeTableRow<S>, S, ? super DragEvent> toOnDragDropped;
    private BiConsumer<S, ? super DragEvent> toOnDragEntered;
    private TriConsumer<TreeTableRow<S>, S, ? super DragEvent> toOnDragExited;
    private TriConsumer<TreeTableRow<S>, S, ? super DragEvent> toOnDragOver;
    private TriConsumer<TreeTableRow<S>, S, ? super MouseDragEvent> toOnMouseDragEntered;
    private final Map<EventType<? extends Event>, BiConsumer<S, ? super Event>> eventFilters = new HashMap<EventType<? extends Event>, BiConsumer<S, ? super Event>>();
    private final Map<PseudoClass, Callback<TreeTableRow<S>, ObservableValue<Boolean>>> pseudoClasses = new HashMap<PseudoClass, Callback<TreeTableRow<S>, ObservableValue<Boolean>>>();

    public ViewModelTreeTableRowFactory<S> withOnMouseClickedEvent(BiConsumer<S, ? super MouseEvent> event) {
        this.onMouseClickedEvent = event;
        return this;
    }

    public ViewModelTreeTableRowFactory<S> withOnMousePressedEvent(BiConsumer<S, ? super MouseEvent> event) {
        this.onMousePressedEvent = event;
        return this;
    }

    public ViewModelTreeTableRowFactory<S> withCustomInitializer(Consumer<TreeTableRow<S>> customInitializer) {
        this.toCustomInitializer = customInitializer;
        return this;
    }

    public ViewModelTreeTableRowFactory<S> withContextMenu(Function<S, ContextMenu> contextMenuFactory) {
        this.contextMenuFactory = contextMenuFactory;
        return this;
    }

    public ViewModelTreeTableRowFactory<S> setOnDragDetected(TriConsumer<TreeTableRow<S>, S, ? super MouseEvent> toOnDragDetected) {
        this.toOnDragDetected = toOnDragDetected;
        return this;
    }

    public ViewModelTreeTableRowFactory<S> setOnDragDetected(BiConsumer<S, ? super MouseEvent> toOnDragDetected) {
        this.toOnDragDetected = (row, viewModel, event) -> toOnDragDetected.accept((Object)viewModel, (MouseEvent)event);
        return this;
    }

    public ViewModelTreeTableRowFactory<S> setOnDragDropped(TriConsumer<TreeTableRow<S>, S, ? super DragEvent> toOnDragDropped) {
        this.toOnDragDropped = toOnDragDropped;
        return this;
    }

    public ViewModelTreeTableRowFactory<S> setOnDragDropped(BiConsumer<S, ? super DragEvent> toOnDragDropped) {
        return this.setOnDragDropped((row, viewModel, event) -> toOnDragDropped.accept((Object)viewModel, (DragEvent)event));
    }

    public ViewModelTreeTableRowFactory<S> setOnDragEntered(BiConsumer<S, ? super DragEvent> toOnDragEntered) {
        this.toOnDragEntered = toOnDragEntered;
        return this;
    }

    public ViewModelTreeTableRowFactory<S> setOnMouseDragEntered(TriConsumer<TreeTableRow<S>, S, ? super MouseDragEvent> toOnDragEntered) {
        this.toOnMouseDragEntered = toOnDragEntered;
        return this;
    }

    public ViewModelTreeTableRowFactory<S> setOnMouseDragEntered(BiConsumer<S, ? super MouseDragEvent> toOnDragEntered) {
        return this.setOnMouseDragEntered((row, viewModel, event) -> toOnDragEntered.accept((Object)viewModel, (MouseDragEvent)event));
    }

    public ViewModelTreeTableRowFactory<S> setOnDragExited(TriConsumer<TreeTableRow<S>, S, ? super DragEvent> toOnDragExited) {
        this.toOnDragExited = toOnDragExited;
        return this;
    }

    public ViewModelTreeTableRowFactory<S> setOnDragExited(BiConsumer<S, ? super DragEvent> toOnDragExited) {
        return this.setOnDragExited((row, viewModel, event) -> toOnDragExited.accept((Object)viewModel, (DragEvent)event));
    }

    public ViewModelTreeTableRowFactory<S> setOnDragOver(TriConsumer<TreeTableRow<S>, S, ? super DragEvent> toOnDragOver) {
        this.toOnDragOver = toOnDragOver;
        return this;
    }

    public ViewModelTreeTableRowFactory<S> setOnDragOver(BiConsumer<S, ? super DragEvent> toOnDragOver) {
        return this.setOnDragOver((row, viewModel, event) -> toOnDragOver.accept((Object)viewModel, (DragEvent)event));
    }

    public ViewModelTreeTableRowFactory<S> withPseudoClass(PseudoClass pseudoClass, Callback<TreeTableRow<S>, ObservableValue<Boolean>> toCondition) {
        this.pseudoClasses.putIfAbsent(pseudoClass, toCondition);
        return this;
    }

    public ViewModelTreeTableRowFactory<S> withEventFilter(EventType<? extends Event> event, BiConsumer<S, ? super Event> toCondition) {
        this.eventFilters.putIfAbsent(event, toCondition);
        return this;
    }

    public void install(TreeTableView<S> table) {
        table.setRowFactory((Callback)this);
    }

    public TreeTableRow<S> call(final TreeTableView<S> treeTableView) {
        return new TreeTableRow<S>(){
            final List<Subscription> subscriptions = new ArrayList<Subscription>();

            protected void updateItem(S row, boolean empty) {
                super.updateItem(row, empty);
                this.subscriptions.forEach(Subscription::unsubscribe);
                this.subscriptions.clear();
                if (ViewModelTreeTableRowFactory.this.contextMenuFactory != null) {
                    this.setOnContextMenuRequested(event -> {
                        if (!this.isEmpty()) {
                            this.setContextMenu(ViewModelTreeTableRowFactory.this.contextMenuFactory.apply(row));
                            this.getContextMenu().show((Node)this, event.getScreenX(), event.getScreenY());
                        }
                        event.consume();
                    });
                    treeTableView.addEventHandler(KeyEvent.KEY_RELEASED, event -> {
                        boolean rowFocused;
                        boolean bl = rowFocused = this.isEmpty() && treeTableView.getFocusModel().getFocusedIndex() == this.getIndex();
                        if (event.getCode() == KeyCode.CONTEXT_MENU && rowFocused) {
                            Bounds anchorBounds = this.getBoundsInParent();
                            double x = anchorBounds.getMinX() + anchorBounds.getWidth() / 2.0;
                            double y = anchorBounds.getMinY() + anchorBounds.getHeight() / 2.0;
                            Point2D screenPosition = this.getParent().localToScreen(x, y);
                            if (this.getContextMenu() == null) {
                                this.setContextMenu(ViewModelTreeTableRowFactory.this.contextMenuFactory.apply(this.getItem()));
                            }
                            this.getContextMenu().show((Node)this, screenPosition.getX(), screenPosition.getY());
                        }
                    });
                }
                if (!empty && row != null) {
                    if (ViewModelTreeTableRowFactory.this.onMouseClickedEvent != null) {
                        this.setOnMouseClicked(event -> ViewModelTreeTableRowFactory.this.onMouseClickedEvent.accept(this.getItem(), (MouseEvent)event));
                    }
                    if (ViewModelTreeTableRowFactory.this.onMousePressedEvent != null) {
                        this.setOnMousePressed(event -> ViewModelTreeTableRowFactory.this.onMousePressedEvent.accept(this.getItem(), (MouseEvent)event));
                    }
                    if (ViewModelTreeTableRowFactory.this.toCustomInitializer != null) {
                        ViewModelTreeTableRowFactory.this.toCustomInitializer.accept(this);
                    }
                    if (ViewModelTreeTableRowFactory.this.toOnDragDetected != null) {
                        this.setOnDragDetected(event -> ViewModelTreeTableRowFactory.this.toOnDragDetected.accept((Object)this, this.getItem(), (Object)event));
                    }
                    if (ViewModelTreeTableRowFactory.this.toOnDragDropped != null) {
                        this.setOnDragDropped(event -> ViewModelTreeTableRowFactory.this.toOnDragDropped.accept((Object)this, this.getItem(), (Object)event));
                    }
                    if (ViewModelTreeTableRowFactory.this.toOnDragEntered != null) {
                        this.setOnDragEntered(event -> ViewModelTreeTableRowFactory.this.toOnDragEntered.accept(this.getItem(), (DragEvent)event));
                    }
                    if (ViewModelTreeTableRowFactory.this.toOnDragExited != null) {
                        this.setOnDragExited(event -> ViewModelTreeTableRowFactory.this.toOnDragExited.accept((Object)this, this.getItem(), (Object)event));
                    }
                    if (ViewModelTreeTableRowFactory.this.toOnDragOver != null) {
                        this.setOnDragOver(event -> ViewModelTreeTableRowFactory.this.toOnDragOver.accept((Object)this, this.getItem(), (Object)event));
                    }
                    if (ViewModelTreeTableRowFactory.this.toOnMouseDragEntered != null) {
                        this.setOnMouseDragEntered(event -> ViewModelTreeTableRowFactory.this.toOnMouseDragEntered.accept((Object)this, this.getItem(), (Object)event));
                    }
                    for (Map.Entry entry : ViewModelTreeTableRowFactory.this.eventFilters.entrySet()) {
                        this.addEventFilter(entry.getKey(), event -> ((BiConsumer)eventFilter.getValue()).accept(this.getItem(), event));
                    }
                    for (Map.Entry entry : ViewModelTreeTableRowFactory.this.pseudoClasses.entrySet()) {
                        ObservableValue condition = (ObservableValue)((Callback)entry.getValue()).call((Object)this);
                        this.subscriptions.add(BindingsHelper.includePseudoClassWhen((Node)this, (PseudoClass)entry.getKey(), (ObservableValue<? extends Boolean>)condition));
                    }
                }
            }
        };
    }
}

