/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.util;

import java.util.concurrent.CountDownLatch;
import javafx.application.Platform;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.TransformationList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UiThreadList<T>
extends TransformationList<T, T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UiThreadList.class);

    public UiThreadList(ObservableList<? extends T> source) {
        super(source);
    }

    protected void sourceChanged(ListChangeListener.Change<? extends T> change) {
        if (Platform.isFxApplicationThread()) {
            this.fireChange(change);
        } else {
            CountDownLatch latch = new CountDownLatch(1);
            Platform.runLater(() -> {
                this.fireChange(change);
                latch.countDown();
            });
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                LOGGER.error("Error while running on JavaFX thread", (Throwable)e);
            }
        }
    }

    public int getSourceIndex(int index) {
        return index;
    }

    public int getViewIndex(int index) {
        return index;
    }

    public T get(int index) {
        return (T)this.getSource().get(index);
    }

    public int size() {
        return this.getSource().size();
    }
}

