/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.util;

import com.google.common.collect.ImmutableMap;
import com.tobiasdiez.easybind.EasyBind;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.scene.Node;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.l10n.Localization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BackgroundTask<V> {
    public static ImmutableMap<String, Node> iconMap = ImmutableMap.of((Object)Localization.lang("Downloading", new Object[0]), (Object)IconTheme.JabRefIcons.DOWNLOAD.getGraphicNode());
    private static final Logger LOGGER = LoggerFactory.getLogger(BackgroundTask.class);
    private Runnable onRunning;
    private Consumer<V> onSuccess;
    private Consumer<Exception> onException;
    private Runnable onFinished;
    private final BooleanProperty isCanceled = new SimpleBooleanProperty(false);
    private final ObjectProperty<BackgroundProgress> progress = new SimpleObjectProperty((Object)new BackgroundProgress(0.0, 0.0));
    private final StringProperty message = new SimpleStringProperty("");
    private final StringProperty title = new SimpleStringProperty(this.getClass().getSimpleName());
    private final DoubleProperty workDonePercentage = new SimpleDoubleProperty(0.0);
    private final BooleanProperty showToUser = new SimpleBooleanProperty(false);
    private final BooleanProperty willBeRecoveredAutomatically = new SimpleBooleanProperty(false);

    public BackgroundTask() {
        this.workDonePercentage.bind((ObservableValue)EasyBind.map(this.progress, BackgroundProgress::getWorkDonePercentage));
    }

    public static <V> BackgroundTask<V> wrap(final Callable<V> callable) {
        return new BackgroundTask<V>(){

            @Override
            protected V call() throws Exception {
                return callable.call();
            }
        };
    }

    public static BackgroundTask<Void> wrap(final Runnable runnable) {
        return new BackgroundTask<Void>(){

            @Override
            protected Void call() {
                runnable.run();
                return null;
            }
        };
    }

    private static <T> Consumer<T> chain(Runnable first, Consumer<T> second) {
        if (first != null) {
            if (second != null) {
                return result -> {
                    first.run();
                    second.accept(result);
                };
            }
            return result -> first.run();
        }
        return second;
    }

    public boolean isCanceled() {
        return this.isCanceled.get();
    }

    public void cancel() {
        LOGGER.debug("Canceling task");
        this.isCanceled.set(true);
    }

    public BooleanProperty isCanceledProperty() {
        return this.isCanceled;
    }

    public StringProperty messageProperty() {
        return this.message;
    }

    public StringProperty titleProperty() {
        return this.title;
    }

    public double getWorkDonePercentage() {
        return this.workDonePercentage.get();
    }

    public DoubleProperty workDonePercentageProperty() {
        return this.workDonePercentage;
    }

    protected BackgroundProgress getProgress() {
        return (BackgroundProgress)this.progress.get();
    }

    protected ObjectProperty<BackgroundProgress> progressProperty() {
        return this.progress;
    }

    public boolean showToUser() {
        return this.showToUser.get();
    }

    public BackgroundTask<V> showToUser(boolean show) {
        this.showToUser.set(show);
        return this;
    }

    public boolean willBeRecoveredAutomatically() {
        return this.willBeRecoveredAutomatically.get();
    }

    public void willBeRecoveredAutomatically(boolean willBeRecoveredAutomatically) {
        this.willBeRecoveredAutomatically.set(willBeRecoveredAutomatically);
    }

    public BackgroundTask<V> onRunning(Runnable onRunning) {
        this.onRunning = onRunning;
        return this;
    }

    public BackgroundTask<V> onSuccess(Consumer<V> onSuccess) {
        this.onSuccess = onSuccess;
        return this;
    }

    protected abstract V call() throws Exception;

    Runnable getOnRunning() {
        return this.onRunning;
    }

    Consumer<V> getOnSuccess() {
        return BackgroundTask.chain(this.onFinished, this.onSuccess);
    }

    Consumer<Exception> getOnException() {
        return BackgroundTask.chain(this.onFinished, this.onException);
    }

    public BackgroundTask<V> onFailure(Consumer<Exception> onException) {
        this.onException = onException;
        return this;
    }

    public Future<?> executeWith(TaskExecutor taskExecutor) {
        return taskExecutor.execute(this);
    }

    public Future<?> scheduleWith(TaskExecutor taskExecutor, long delay, TimeUnit unit) {
        return taskExecutor.schedule(this, delay, unit);
    }

    public BackgroundTask<V> onFinished(Runnable onFinished) {
        this.onFinished = onFinished;
        return this;
    }

    public <T> BackgroundTask<T> then(final Function<V, BackgroundTask<T>> nextTaskFactory) {
        return new BackgroundTask<T>(){

            @Override
            protected T call() throws Exception {
                Object result = BackgroundTask.this.call();
                BackgroundTask nextTask = (BackgroundTask)nextTaskFactory.apply(result);
                EasyBind.subscribe(nextTask.progressProperty(), this::updateProgress);
                return nextTask.call();
            }
        };
    }

    public <T> BackgroundTask<T> thenRun(final Function<V, T> nextOperation) {
        return new BackgroundTask<T>(){

            @Override
            protected T call() throws Exception {
                Object result = BackgroundTask.this.call();
                BackgroundTask<Object> nextTask = BackgroundTask.wrap(() -> nextOperation.apply(result));
                EasyBind.subscribe(nextTask.progressProperty(), this::updateProgress);
                return nextTask.call();
            }
        };
    }

    public BackgroundTask<Void> thenRun(final Consumer<V> nextOperation) {
        return new BackgroundTask<Void>(){

            @Override
            protected Void call() throws Exception {
                Object result = BackgroundTask.this.call();
                BackgroundTask<Void> nextTask = BackgroundTask.wrap(() -> nextOperation.accept(result));
                EasyBind.subscribe(nextTask.progressProperty(), this::updateProgress);
                return nextTask.call();
            }
        };
    }

    protected void updateProgress(BackgroundProgress newProgress) {
        this.progress.setValue((Object)newProgress);
    }

    protected void updateProgress(double workDone, double max) {
        this.updateProgress(new BackgroundProgress(workDone, max));
    }

    public void updateMessage(String newMessage) {
        this.message.setValue(newMessage);
    }

    public BackgroundTask<V> withInitialMessage(String message) {
        this.updateMessage(message);
        return this;
    }

    public static Node getIcon(Task<?> task) {
        return (Node)iconMap.getOrDefault((Object)task.getTitle(), null);
    }

    protected record BackgroundProgress(double workDone, double max) {
        public double getWorkDonePercentage() {
            if (this.max == 0.0) {
                return 0.0;
            }
            return this.workDone / this.max;
        }
    }
}

