/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.theme;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Base64;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.jabref.gui.theme.StyleSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class StyleSheetFile
extends StyleSheet {
    static final int MAX_IN_MEMORY_CSS_LENGTH = 48000;
    private static final Logger LOGGER = LoggerFactory.getLogger(StyleSheetFile.class);
    private final URL url;
    private final Path path;
    private final AtomicReference<String> dataUrl = new AtomicReference();

    StyleSheetFile(URL url) {
        this.url = url;
        this.path = Path.of(URI.create(url.toExternalForm()));
        this.reload();
    }

    @Override
    Path getWatchPath() {
        return this.path;
    }

    @Override
    void reload() {
        StyleSheetFile.getDataUrl(this.url).ifPresentOrElse(this.dataUrl::set, () -> this.dataUrl.set(""));
    }

    @Override
    public URL getSceneStylesheet() {
        if (!Files.exists(this.path, new LinkOption[0])) {
            LOGGER.warn("Cannot load additional css {} because the file does not exist.", (Object)this.path);
            return null;
        }
        if (Files.isDirectory(this.path, new LinkOption[0])) {
            LOGGER.warn("Failed to loadCannot load additional css {} because it is a directory.", (Object)this.path);
            return null;
        }
        return this.url;
    }

    @Override
    public String getWebEngineStylesheet() {
        if (Strings.isNullOrEmpty((String)this.dataUrl.get())) {
            this.reload();
        }
        if (Strings.isNullOrEmpty((String)this.dataUrl.get())) {
            URL stylesheet = this.getSceneStylesheet();
            return stylesheet == null ? "" : stylesheet.toExternalForm();
        }
        return this.dataUrl.get();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Optional<String> getDataUrl(URL url) {
        try {
            URLConnection conn = url.openConnection();
            conn.connect();
            try (InputStream inputStream = conn.getInputStream();){
                byte[] data = inputStream.readNBytes(48000);
                if (data.length < 48000) {
                    String embeddedDataUrl = "data:text/css;charset=utf-8;base64," + Base64.getEncoder().encodeToString(data);
                    LOGGER.debug("Embedded css in data URL of length {}", (Object)embeddedDataUrl.length());
                    Optional<CallSite> optional = Optional.of(embeddedDataUrl);
                    return optional;
                }
                LOGGER.debug("Not embedding css in data URL as the length is >= {}", (Object)48000);
                return Optional.empty();
            }
        }
        catch (IOException e) {
            LOGGER.warn("Could not load css url {}", (Object)url, (Object)e);
        }
        return Optional.empty();
    }

    @Override
    public String toString() {
        return "StyleSheet{" + String.valueOf(this.getSceneStylesheet()) + "}";
    }
}

