/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.texparser;

import com.airhacks.afterburner.injection.Injector;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyListWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.jabref.gui.AbstractViewModel;
import org.jabref.gui.DialogService;
import org.jabref.gui.importer.ImportEntriesDialog;
import org.jabref.gui.texparser.ReferenceViewModel;
import org.jabref.gui.util.BackgroundTask;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.texparser.Citation;
import org.jabref.model.texparser.LatexBibEntriesResolverResult;

public class ParseLatexResultViewModel
extends AbstractViewModel {
    private final LatexBibEntriesResolverResult resolverResult;
    private final BibDatabaseContext databaseContext;
    private final ObservableList<ReferenceViewModel> referenceList;
    private final ObservableList<Citation> citationList;
    private final BooleanProperty importButtonDisabled;

    public ParseLatexResultViewModel(LatexBibEntriesResolverResult resolverResult, BibDatabaseContext databaseContext) {
        this.resolverResult = resolverResult;
        this.databaseContext = databaseContext;
        this.referenceList = FXCollections.observableArrayList();
        this.citationList = FXCollections.observableArrayList();
        Set newEntryKeys = resolverResult.getNewEntries().stream().map(entry -> entry.getCitationKey().orElse("")).collect(Collectors.toSet());
        for (Map.Entry entry2 : resolverResult.getCitations().asMap().entrySet()) {
            String key = (String)entry2.getKey();
            this.referenceList.add((Object)new ReferenceViewModel(key, newEntryKeys.contains(key), (Collection)entry2.getValue()));
        }
        this.importButtonDisabled = new SimpleBooleanProperty(this.referenceList.stream().noneMatch(ReferenceViewModel::isHighlighted));
    }

    public ObservableList<ReferenceViewModel> getReferenceList() {
        return new ReadOnlyListWrapper(this.referenceList);
    }

    public ObservableList<Citation> getCitationListByReference() {
        return new ReadOnlyListWrapper(this.citationList);
    }

    public BooleanProperty importButtonDisabledProperty() {
        return this.importButtonDisabled;
    }

    public void activeReferenceChanged(ReferenceViewModel reference) {
        if (reference == null) {
            this.citationList.clear();
        } else {
            this.citationList.setAll(reference.getCitationList());
        }
    }

    public void importButtonClicked() {
        DialogService dialogService = (DialogService)Injector.instantiateModelOrService(DialogService.class);
        ImportEntriesDialog dialog = new ImportEntriesDialog(this.databaseContext, BackgroundTask.wrap(() -> new ParserResult(this.resolverResult.getNewEntries())));
        dialog.setTitle(Localization.lang("Import entries from LaTeX files", new Object[0]));
        dialogService.showCustomDialogAndWait(dialog);
    }
}

