/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.texparser;

import de.saxsys.mvvmfx.utils.validation.FunctionBasedValidator;
import de.saxsys.mvvmfx.utils.validation.ValidationMessage;
import de.saxsys.mvvmfx.utils.validation.ValidationStatus;
import de.saxsys.mvvmfx.utils.validation.Validator;
import java.io.IOException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyListWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.TreeItem;
import org.jabref.gui.AbstractViewModel;
import org.jabref.gui.DialogService;
import org.jabref.gui.texparser.ParseLatexResultView;
import org.jabref.gui.util.BackgroundTask;
import org.jabref.gui.util.DirectoryDialogConfiguration;
import org.jabref.gui.util.FileNodeViewModel;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.texparser.DefaultLatexParser;
import org.jabref.logic.texparser.TexBibEntriesResolver;
import org.jabref.logic.util.io.FileUtil;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.texparser.LatexBibEntriesResolverResult;
import org.jabref.model.util.FileUpdateMonitor;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParseLatexDialogViewModel
extends AbstractViewModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParseLatexDialogViewModel.class);
    private static final String TEX_EXT = ".tex";
    private final BibDatabaseContext databaseContext;
    private final DialogService dialogService;
    private final TaskExecutor taskExecutor;
    private final PreferencesService preferencesService;
    private final FileUpdateMonitor fileMonitor;
    private final StringProperty latexFileDirectory;
    private final Validator latexDirectoryValidator;
    private final ObjectProperty<FileNodeViewModel> root;
    private final ObservableList<TreeItem<FileNodeViewModel>> checkedFileList;
    private final BooleanProperty noFilesFound;
    private final BooleanProperty searchInProgress;
    private final BooleanProperty successfulSearch;

    public ParseLatexDialogViewModel(BibDatabaseContext databaseContext, DialogService dialogService, TaskExecutor taskExecutor, PreferencesService preferencesService, FileUpdateMonitor fileMonitor) {
        this.databaseContext = databaseContext;
        this.dialogService = dialogService;
        this.taskExecutor = taskExecutor;
        this.preferencesService = preferencesService;
        this.fileMonitor = fileMonitor;
        this.latexFileDirectory = new SimpleStringProperty(databaseContext.getMetaData().getLatexFileDirectory(preferencesService.getFilePreferences().getUserAndHost()).orElse(FileUtil.getInitialDirectory(databaseContext, preferencesService.getFilePreferences().getWorkingDirectory())).toAbsolutePath().toString());
        this.root = new SimpleObjectProperty();
        this.checkedFileList = FXCollections.observableArrayList();
        this.noFilesFound = new SimpleBooleanProperty(true);
        this.searchInProgress = new SimpleBooleanProperty(false);
        this.successfulSearch = new SimpleBooleanProperty(false);
        Predicate<String> isDirectory = path -> Path.of(path, new String[0]).toFile().isDirectory();
        this.latexDirectoryValidator = new FunctionBasedValidator((ObservableValue)this.latexFileDirectory, isDirectory, ValidationMessage.error((String)Localization.lang("Please enter a valid file path.", new Object[0])));
    }

    public StringProperty latexFileDirectoryProperty() {
        return this.latexFileDirectory;
    }

    public ValidationStatus latexDirectoryValidation() {
        return this.latexDirectoryValidator.getValidationStatus();
    }

    public ObjectProperty<FileNodeViewModel> rootProperty() {
        return this.root;
    }

    public ObservableList<TreeItem<FileNodeViewModel>> getCheckedFileList() {
        return new ReadOnlyListWrapper(this.checkedFileList);
    }

    public BooleanProperty noFilesFoundProperty() {
        return this.noFilesFound;
    }

    public BooleanProperty searchInProgressProperty() {
        return this.searchInProgress;
    }

    public BooleanProperty successfulSearchProperty() {
        return this.successfulSearch;
    }

    public void browseButtonClicked() {
        DirectoryDialogConfiguration directoryDialogConfiguration = new DirectoryDialogConfiguration.Builder().withInitialDirectory(Path.of((String)this.latexFileDirectory.get(), new String[0])).build();
        this.dialogService.showDirectorySelectionDialog(directoryDialogConfiguration).ifPresent(selectedDirectory -> {
            this.latexFileDirectory.set((Object)selectedDirectory.toAbsolutePath().toString());
            this.preferencesService.getFilePreferences().setWorkingDirectory(selectedDirectory.toAbsolutePath());
        });
    }

    public void searchButtonClicked() {
        BackgroundTask.wrap(() -> this.searchDirectory(Path.of((String)this.latexFileDirectory.get(), new String[0]))).onRunning(() -> {
            this.root.set(null);
            this.noFilesFound.set(true);
            this.searchInProgress.set(true);
            this.successfulSearch.set(false);
        }).onFinished(() -> this.searchInProgress.set(false)).onSuccess(newRoot -> {
            this.root.set(newRoot);
            this.noFilesFound.set(false);
            this.successfulSearch.set(true);
        }).onFailure(this::handleFailure).executeWith(this.taskExecutor);
    }

    private void handleFailure(Exception exception) {
        boolean permissionProblem;
        boolean bl = permissionProblem = exception instanceof IOException && exception.getCause() instanceof FileSystemException && exception.getCause().getMessage().endsWith("Operation not permitted");
        if (permissionProblem) {
            this.dialogService.showErrorDialogAndWait(Localization.lang("JabRef does not have permission to access %s", new Object[0]).formatted(exception.getCause().getMessage()));
        } else {
            this.dialogService.showErrorDialogAndWait(exception);
        }
    }

    private FileNodeViewModel searchDirectory(Path directory) throws IOException {
        Map<Boolean, List<Path>> fileListPartition;
        if (directory == null || !directory.toFile().isDirectory()) {
            throw new IOException("Invalid directory for searching: %s".formatted(directory));
        }
        FileNodeViewModel parent = new FileNodeViewModel(directory);
        try (Stream<Path> filesStream = Files.list(directory);){
            fileListPartition = filesStream.collect(Collectors.partitioningBy(path -> path.toFile().isDirectory()));
        }
        catch (IOException e) {
            LOGGER.error("%s while searching files: %s".formatted(e.getClass().getName(), e.getMessage()));
            return parent;
        }
        List<Path> subDirectories = fileListPartition.get(true);
        List<Path> files = fileListPartition.get(false).stream().filter(path -> path.toString().endsWith(TEX_EXT)).toList();
        int fileCount = 0;
        for (Path subDirectory : subDirectories) {
            FileNodeViewModel subRoot = this.searchDirectory(subDirectory);
            if (subRoot.getChildren().isEmpty()) continue;
            fileCount += subRoot.getFileCount();
            parent.getChildren().add((Object)subRoot);
        }
        parent.setFileCount(files.size() + fileCount);
        parent.getChildren().addAll(files.stream().map(FileNodeViewModel::new).toList());
        return parent;
    }

    public void parseButtonClicked() {
        List<Path> fileList = this.checkedFileList.stream().map(item -> ((FileNodeViewModel)item.getValue()).getPath()).filter(path -> path.toFile().isFile()).toList();
        if (fileList.isEmpty()) {
            LOGGER.warn("There are no valid files checked");
            return;
        }
        TexBibEntriesResolver entriesResolver = new TexBibEntriesResolver(this.databaseContext.getDatabase(), this.preferencesService.getImportFormatPreferences(), this.fileMonitor);
        BackgroundTask.wrap(() -> entriesResolver.resolve(new DefaultLatexParser().parse(fileList))).onRunning(() -> this.searchInProgress.set(true)).onFinished(() -> this.searchInProgress.set(false)).onSuccess(result -> this.dialogService.showCustomDialogAndWait(new ParseLatexResultView((LatexBibEntriesResolverResult)result, this.databaseContext, Path.of((String)this.latexFileDirectory.get(), new String[0])))).onFailure(this.dialogService::showErrorDialogAndWait).executeWith(this.taskExecutor);
    }
}

