/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.texparser;

import com.airhacks.afterburner.views.ViewLoader;
import com.tobiasdiez.easybind.EasyBind;
import de.saxsys.mvvmfx.utils.validation.visualization.ControlsFxVisualizer;
import jakarta.inject.Inject;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBoxTreeItem;
import javafx.scene.control.Control;
import javafx.scene.control.Dialog;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeView;
import org.controlsfx.control.CheckTreeView;
import org.controlsfx.validation.decoration.ValidationDecoration;
import org.jabref.gui.DialogService;
import org.jabref.gui.texparser.ParseLatexDialogViewModel;
import org.jabref.gui.theme.ThemeManager;
import org.jabref.gui.util.BaseDialog;
import org.jabref.gui.util.ControlHelper;
import org.jabref.gui.util.FileNodeViewModel;
import org.jabref.gui.util.IconValidationDecorator;
import org.jabref.gui.util.RecursiveTreeItem;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.gui.util.ViewModelTreeCellFactory;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.util.FileUpdateMonitor;
import org.jabref.preferences.PreferencesService;

public class ParseLatexDialogView
extends BaseDialog<Void> {
    private final BibDatabaseContext databaseContext;
    private final ControlsFxVisualizer validationVisualizer;
    @FXML
    private TextField latexDirectoryField;
    @FXML
    private Button browseButton;
    @FXML
    private Button searchButton;
    @FXML
    private ProgressIndicator progressIndicator;
    @FXML
    private CheckTreeView<FileNodeViewModel> fileTreeView;
    @FXML
    private Button selectAllButton;
    @FXML
    private Button unselectAllButton;
    @FXML
    private ButtonType parseButtonType;
    @Inject
    private DialogService dialogService;
    @Inject
    private TaskExecutor taskExecutor;
    @Inject
    private PreferencesService preferencesService;
    @Inject
    private FileUpdateMonitor fileMonitor;
    @Inject
    private ThemeManager themeManager;
    private ParseLatexDialogViewModel viewModel;

    public ParseLatexDialogView(BibDatabaseContext databaseContext) {
        this.databaseContext = databaseContext;
        this.validationVisualizer = new ControlsFxVisualizer();
        this.setTitle(Localization.lang("Search for citations in LaTeX files...", new Object[0]));
        ViewLoader.view((Object)((Object)this)).load().setAsDialogPane((Dialog)this);
        ControlHelper.setAction(this.parseButtonType, this.getDialogPane(), event -> this.viewModel.parseButtonClicked());
        Button parseButton = (Button)this.getDialogPane().lookupButton(this.parseButtonType);
        parseButton.disableProperty().bind((ObservableValue)this.viewModel.noFilesFoundProperty().or((ObservableBooleanValue)Bindings.isEmpty(this.viewModel.getCheckedFileList())));
        this.themeManager.updateFontStyle(this.getDialogPane().getScene());
    }

    @FXML
    private void initialize() {
        this.viewModel = new ParseLatexDialogViewModel(this.databaseContext, this.dialogService, this.taskExecutor, this.preferencesService, this.fileMonitor);
        this.fileTreeView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.fileTreeView.showRootProperty().bindBidirectional((Property)this.viewModel.successfulSearchProperty());
        this.fileTreeView.rootProperty().bind((ObservableValue)EasyBind.map(this.viewModel.rootProperty(), fileNode -> new RecursiveTreeItem<FileNodeViewModel>((FileNodeViewModel)fileNode, FileNodeViewModel::getChildren)));
        new ViewModelTreeCellFactory().withText(FileNodeViewModel::getDisplayText).install((TreeView<FileNodeViewModel>)this.fileTreeView);
        EasyBind.subscribe((ObservableValue)this.fileTreeView.rootProperty(), root -> {
            ((CheckBoxTreeItem)root).setSelected(true);
            root.setExpanded(true);
            EasyBind.bindContent(this.viewModel.getCheckedFileList(), (ObservableList)this.fileTreeView.getCheckModel().getCheckedItems());
        });
        this.latexDirectoryField.textProperty().bindBidirectional((Property)this.viewModel.latexFileDirectoryProperty());
        this.validationVisualizer.setDecoration((ValidationDecoration)new IconValidationDecorator());
        this.validationVisualizer.initVisualization(this.viewModel.latexDirectoryValidation(), (Control)this.latexDirectoryField);
        this.browseButton.disableProperty().bindBidirectional((Property)this.viewModel.searchInProgressProperty());
        this.searchButton.disableProperty().bind((ObservableValue)this.viewModel.latexDirectoryValidation().validProperty().not());
        this.selectAllButton.disableProperty().bindBidirectional((Property)this.viewModel.noFilesFoundProperty());
        this.unselectAllButton.disableProperty().bindBidirectional((Property)this.viewModel.noFilesFoundProperty());
        this.progressIndicator.visibleProperty().bindBidirectional((Property)this.viewModel.searchInProgressProperty());
    }

    @FXML
    private void browseButtonClicked() {
        this.viewModel.browseButtonClicked();
    }

    @FXML
    private void searchButtonClicked() {
        this.viewModel.searchButtonClicked();
    }

    @FXML
    private void selectAll() {
        this.fileTreeView.getCheckModel().checkAll();
    }

    @FXML
    private void unselectAll() {
        this.fileTreeView.getCheckModel().clearChecks();
    }
}

