/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.specialfields;

import java.util.Objects;
import java.util.Optional;
import org.jabref.gui.actions.Action;
import org.jabref.gui.actions.StandardActions;
import org.jabref.gui.icon.JabRefIcon;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.field.SpecialFieldValue;

public class SpecialFieldValueViewModel {
    private final SpecialFieldValue value;

    public SpecialFieldValueViewModel(SpecialFieldValue value) {
        Objects.requireNonNull(value);
        this.value = value;
    }

    public SpecialFieldValue getValue() {
        return this.value;
    }

    public Optional<JabRefIcon> getIcon() {
        return this.getAction().getIcon();
    }

    public String getMenuString() {
        return this.getAction().getText();
    }

    public String getToolTipText() {
        return switch (this.value) {
            default -> throw new MatchException(null, null);
            case SpecialFieldValue.PRINTED -> Localization.lang("Toggle print status", new Object[0]);
            case SpecialFieldValue.CLEAR_PRIORITY -> Localization.lang("No priority information", new Object[0]);
            case SpecialFieldValue.PRIORITY_HIGH -> Localization.lang("Priority high", new Object[0]);
            case SpecialFieldValue.PRIORITY_MEDIUM -> Localization.lang("Priority medium", new Object[0]);
            case SpecialFieldValue.PRIORITY_LOW -> Localization.lang("Priority low", new Object[0]);
            case SpecialFieldValue.QUALITY_ASSURED -> Localization.lang("Toggle quality assured", new Object[0]);
            case SpecialFieldValue.CLEAR_RANK -> Localization.lang("No rank information", new Object[0]);
            case SpecialFieldValue.RANK_1 -> Localization.lang("One star", new Object[0]);
            case SpecialFieldValue.RANK_2 -> Localization.lang("Two stars", new Object[0]);
            case SpecialFieldValue.RANK_3 -> Localization.lang("Three stars", new Object[0]);
            case SpecialFieldValue.RANK_4 -> Localization.lang("Four stars", new Object[0]);
            case SpecialFieldValue.RANK_5 -> Localization.lang("Five stars", new Object[0]);
            case SpecialFieldValue.CLEAR_READ_STATUS -> Localization.lang("No read status information", new Object[0]);
            case SpecialFieldValue.READ -> Localization.lang("Read status read", new Object[0]);
            case SpecialFieldValue.SKIMMED -> Localization.lang("Read status skimmed", new Object[0]);
            case SpecialFieldValue.RELEVANT -> Localization.lang("Toggle relevance", new Object[0]);
        };
    }

    public Action getAction() {
        return switch (this.value) {
            default -> throw new MatchException(null, null);
            case SpecialFieldValue.PRINTED -> StandardActions.TOGGLE_PRINTED;
            case SpecialFieldValue.CLEAR_PRIORITY -> StandardActions.CLEAR_PRIORITY;
            case SpecialFieldValue.PRIORITY_HIGH -> StandardActions.PRIORITY_HIGH;
            case SpecialFieldValue.PRIORITY_MEDIUM -> StandardActions.PRIORITY_MEDIUM;
            case SpecialFieldValue.PRIORITY_LOW -> StandardActions.PRIORITY_LOW;
            case SpecialFieldValue.QUALITY_ASSURED -> StandardActions.QUALITY_ASSURED;
            case SpecialFieldValue.CLEAR_RANK -> StandardActions.CLEAR_RANK;
            case SpecialFieldValue.RANK_1 -> StandardActions.RANK_1;
            case SpecialFieldValue.RANK_2 -> StandardActions.RANK_2;
            case SpecialFieldValue.RANK_3 -> StandardActions.RANK_3;
            case SpecialFieldValue.RANK_4 -> StandardActions.RANK_4;
            case SpecialFieldValue.RANK_5 -> StandardActions.RANK_5;
            case SpecialFieldValue.CLEAR_READ_STATUS -> StandardActions.CLEAR_READ_STATUS;
            case SpecialFieldValue.READ -> StandardActions.READ;
            case SpecialFieldValue.SKIMMED -> StandardActions.SKIMMED;
            case SpecialFieldValue.RELEVANT -> StandardActions.RELEVANT;
        };
    }
}

