/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.slr;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.jabref.gui.DialogService;
import org.jabref.gui.LibraryTabContainer;
import org.jabref.gui.StateManager;
import org.jabref.gui.importer.actions.OpenDatabaseAction;
import org.jabref.gui.slr.ExistingStudySearchAction;
import org.jabref.gui.slr.ManageStudyDefinitionView;
import org.jabref.gui.slr.SlrStudyAndDirectory;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.crawler.StudyYamlParser;
import org.jabref.logic.git.GitHandler;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.study.Study;
import org.jabref.model.util.FileUpdateMonitor;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartNewStudyAction
extends ExistingStudySearchAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(StartNewStudyAction.class);
    Study newStudy;

    public StartNewStudyAction(LibraryTabContainer tabContainer, Supplier<OpenDatabaseAction> openDatabaseActionSupplier, FileUpdateMonitor fileUpdateMonitor, TaskExecutor taskExecutor, PreferencesService preferencesService, StateManager stateManager, DialogService dialogService) {
        super(tabContainer, openDatabaseActionSupplier, dialogService, fileUpdateMonitor, taskExecutor, preferencesService, stateManager, true);
    }

    @Override
    protected void crawlPreparation(Path studyRepositoryRoot) throws IOException, GitAPIException {
        StudyYamlParser studyYAMLParser = new StudyYamlParser();
        studyYAMLParser.writeStudyYamlFile(this.newStudy, studyRepositoryRoot.resolve("study.yml"));
        new GitHandler(studyRepositoryRoot).createCommitOnCurrentBranch("Initial commit", true);
    }

    @Override
    public void execute() {
        Optional<SlrStudyAndDirectory> studyAndDirectory = this.dialogService.showCustomDialogAndWait(new ManageStudyDefinitionView(this.preferencesService.getFilePreferences().getWorkingDirectory()));
        if (studyAndDirectory.isEmpty()) {
            return;
        }
        if (studyAndDirectory.get().getStudyDirectory().toString().isBlank()) {
            LOGGER.error("Study directory is blank");
            this.dialogService.showErrorDialogAndWait(Localization.lang("Must not be empty!", new Object[0]));
            return;
        }
        this.studyDirectory = studyAndDirectory.get().getStudyDirectory();
        this.newStudy = studyAndDirectory.get().getStudy();
        this.crawl();
    }
}

