/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.sidepane;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import javafx.collections.ObservableList;
import javax.swing.undo.UndoManager;
import org.jabref.gui.AbstractViewModel;
import org.jabref.gui.ClipBoardManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.LibraryTabContainer;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.sidepane.GroupsSidePaneComponent;
import org.jabref.gui.sidepane.SidePaneComponent;
import org.jabref.gui.sidepane.SidePaneContentFactory;
import org.jabref.gui.sidepane.SidePaneType;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.journals.JournalAbbreviationRepository;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.model.util.FileUpdateMonitor;
import org.jabref.preferences.PreferencesService;
import org.jabref.preferences.SidePanePreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SidePaneViewModel
extends AbstractViewModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(SidePaneViewModel.class);
    private final Map<SidePaneType, SidePaneComponent> sidePaneComponentLookup = new HashMap<SidePaneType, SidePaneComponent>();
    private final PreferencesService preferencesService;
    private final StateManager stateManager;
    private final SidePaneContentFactory sidePaneContentFactory;
    private final DialogService dialogService;

    public SidePaneViewModel(LibraryTabContainer tabContainer, PreferencesService preferencesService, JournalAbbreviationRepository abbreviationRepository, StateManager stateManager, TaskExecutor taskExecutor, DialogService dialogService, FileUpdateMonitor fileUpdateMonitor, BibEntryTypesManager entryTypesManager, ClipBoardManager clipBoardManager, UndoManager undoManager) {
        this.preferencesService = preferencesService;
        this.stateManager = stateManager;
        this.dialogService = dialogService;
        this.sidePaneContentFactory = new SidePaneContentFactory(tabContainer, preferencesService, abbreviationRepository, taskExecutor, dialogService, stateManager, fileUpdateMonitor, entryTypesManager, clipBoardManager, undoManager);
        preferencesService.getSidePanePreferences().visiblePanes().forEach(this::show);
        this.getPanes().addListener(change -> {
            while (change.next()) {
                if (change.wasAdded()) {
                    preferencesService.getSidePanePreferences().visiblePanes().add((Object)((SidePaneType)((Object)((Object)change.getAddedSubList().getFirst()))));
                    continue;
                }
                if (!change.wasRemoved()) continue;
                preferencesService.getSidePanePreferences().visiblePanes().remove(change.getRemoved().getFirst());
            }
        });
    }

    protected SidePaneComponent getSidePaneComponent(SidePaneType pane) {
        SidePaneComponent sidePaneComponent = this.sidePaneComponentLookup.get((Object)pane);
        if (sidePaneComponent == null) {
            sidePaneComponent = switch (pane) {
                default -> throw new MatchException(null, null);
                case SidePaneType.GROUPS -> new GroupsSidePaneComponent(new ClosePaneAction(pane), new MoveUpAction(pane), new MoveDownAction(pane), this.sidePaneContentFactory, this.preferencesService.getGroupsPreferences(), this.dialogService);
                case SidePaneType.WEB_SEARCH, SidePaneType.OPEN_OFFICE -> new SidePaneComponent(pane, new ClosePaneAction(pane), new MoveUpAction(pane), new MoveDownAction(pane), this.sidePaneContentFactory);
            };
            this.sidePaneComponentLookup.put(pane, sidePaneComponent);
        }
        return sidePaneComponent;
    }

    private void updatePreferredPositions() {
        HashMap<SidePaneType, Integer> preferredPositions = new HashMap<SidePaneType, Integer>((Map<SidePaneType, Integer>)this.preferencesService.getSidePanePreferences().getPreferredPositions());
        IntStream.range(0, this.getPanes().size()).forEach(i -> preferredPositions.put((SidePaneType)((Object)((Object)this.getPanes().get(i))), i));
        this.preferencesService.getSidePanePreferences().setPreferredPositions(preferredPositions);
    }

    public void moveUp(SidePaneType pane) {
        if (this.getPanes().contains((Object)pane)) {
            int currentPosition = this.getPanes().indexOf((Object)pane);
            if (currentPosition > 0) {
                int newPosition = currentPosition - 1;
                this.swap(this.getPanes(), currentPosition, newPosition);
                this.updatePreferredPositions();
            } else {
                LOGGER.debug("SidePaneComponent is already at the bottom");
            }
        } else {
            LOGGER.warn("SidePaneComponent {} not visible", (Object)pane.getTitle());
        }
    }

    public void moveDown(SidePaneType pane) {
        if (this.getPanes().contains((Object)pane)) {
            int currentPosition = this.getPanes().indexOf((Object)pane);
            if (currentPosition < this.getPanes().size() - 1) {
                int newPosition = currentPosition + 1;
                this.swap(this.getPanes(), currentPosition, newPosition);
                this.updatePreferredPositions();
            } else {
                LOGGER.debug("SidePaneComponent {} is already at the top", (Object)pane.getTitle());
            }
        } else {
            LOGGER.warn("SidePaneComponent {} not visible", (Object)pane.getTitle());
        }
    }

    private void show(SidePaneType pane) {
        if (!this.getPanes().contains((Object)pane)) {
            this.getPanes().add((Object)pane);
            this.getPanes().sort((Comparator)new PreferredIndexSort(this.preferencesService.getSidePanePreferences()));
        } else {
            LOGGER.warn("SidePaneComponent {} not visible", (Object)pane.getTitle());
        }
    }

    private ObservableList<SidePaneType> getPanes() {
        return this.stateManager.getVisibleSidePaneComponents();
    }

    private <T> void swap(ObservableList<T> observableList, int i, int j) {
        ArrayList<T> placeholder = new ArrayList<T>(observableList);
        Collections.swap(placeholder, i, j);
        observableList.sort(Comparator.comparingInt(placeholder::indexOf));
    }

    public class ClosePaneAction
    extends SimpleCommand {
        private final SidePaneType toClosePane;

        public ClosePaneAction(SidePaneType toClosePane) {
            this.toClosePane = toClosePane;
        }

        public void execute() {
            SidePaneViewModel.this.stateManager.getVisibleSidePaneComponents().remove((Object)this.toClosePane);
        }
    }

    private class MoveUpAction
    extends SimpleCommand {
        private final SidePaneType toMoveUpPane;

        public MoveUpAction(SidePaneType toMoveUpPane) {
            this.toMoveUpPane = toMoveUpPane;
        }

        public void execute() {
            SidePaneViewModel.this.moveUp(this.toMoveUpPane);
        }
    }

    private class MoveDownAction
    extends SimpleCommand {
        private final SidePaneType toMoveDownPane;

        public MoveDownAction(SidePaneType toMoveDownPane) {
            this.toMoveDownPane = toMoveDownPane;
        }

        public void execute() {
            SidePaneViewModel.this.moveDown(this.toMoveDownPane);
        }
    }

    protected static class PreferredIndexSort
    implements Comparator<SidePaneType> {
        private final Map<SidePaneType, Integer> preferredPositions;

        public PreferredIndexSort(SidePanePreferences sidePanePreferences) {
            this.preferredPositions = sidePanePreferences.getPreferredPositions();
        }

        @Override
        public int compare(SidePaneType type1, SidePaneType type2) {
            int pos1 = this.preferredPositions.getOrDefault((Object)type1, 0);
            int pos2 = this.preferredPositions.getOrDefault((Object)type2, 0);
            return Integer.compare(pos1, pos2);
        }
    }
}

