/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.search.rules.describer;

import org.jabref.gui.search.rules.describer.ContainsAndRegexBasedSearchRuleDescriber;
import org.jabref.gui.search.rules.describer.GrammarBasedSearchRuleDescriber;
import org.jabref.gui.search.rules.describer.SearchDescriber;
import org.jabref.logic.search.SearchQuery;
import org.jabref.model.search.rules.ContainsBasedSearchRule;
import org.jabref.model.search.rules.GrammarBasedSearchRule;
import org.jabref.model.search.rules.RegexBasedSearchRule;
import org.jabref.model.search.rules.SearchRule;

public class SearchDescribers {
    private SearchDescribers() {
    }

    public static SearchDescriber getSearchDescriberFor(SearchQuery searchQuery) {
        SearchRule searchRule = searchQuery.getRule();
        if (searchRule instanceof GrammarBasedSearchRule) {
            GrammarBasedSearchRule grammarBasedSearchRule = (GrammarBasedSearchRule)searchRule;
            return new GrammarBasedSearchRuleDescriber(grammarBasedSearchRule.getSearchFlags(), grammarBasedSearchRule.getTree());
        }
        searchRule = searchQuery.getRule();
        if (searchRule instanceof ContainsBasedSearchRule) {
            ContainsBasedSearchRule containBasedSearchRule = (ContainsBasedSearchRule)searchRule;
            return new ContainsAndRegexBasedSearchRuleDescriber(containBasedSearchRule.getSearchFlags(), searchQuery.getQuery());
        }
        searchRule = searchQuery.getRule();
        if (searchRule instanceof RegexBasedSearchRule) {
            RegexBasedSearchRule regexBasedSearchRule = (RegexBasedSearchRule)searchRule;
            return new ContainsAndRegexBasedSearchRuleDescriber(regexBasedSearchRule.getSearchFlags(), searchQuery.getQuery());
        }
        throw new IllegalStateException("Cannot find a describer for searchRule " + String.valueOf(searchQuery.getRule()) + " and query " + searchQuery.getQuery());
    }
}

