/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.search;

import java.io.IOException;
import javafx.beans.value.ObservableValue;
import org.jabref.gui.DialogService;
import org.jabref.gui.LibraryTab;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.ActionHelper;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.util.BackgroundTask;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.pdf.search.PdfIndexer;
import org.jabref.logic.pdf.search.PdfIndexerManager;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.preferences.FilePreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RebuildFulltextSearchIndexAction
extends SimpleCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(LibraryTab.class);
    private final StateManager stateManager;
    private final GetCurrentLibraryTab currentLibraryTab;
    private final DialogService dialogService;
    private final FilePreferences filePreferences;
    private final TaskExecutor taskExecutor;
    private BibDatabaseContext databaseContext;
    private boolean shouldContinue = true;

    public RebuildFulltextSearchIndexAction(StateManager stateManager, GetCurrentLibraryTab currentLibraryTab, DialogService dialogService, FilePreferences filePreferences, TaskExecutor taskExecutor) {
        this.stateManager = stateManager;
        this.currentLibraryTab = currentLibraryTab;
        this.dialogService = dialogService;
        this.filePreferences = filePreferences;
        this.taskExecutor = taskExecutor;
        this.executable.bind((ObservableValue)ActionHelper.needsDatabase(stateManager));
    }

    public void execute() {
        this.init();
        BackgroundTask.wrap(this::rebuildIndex).executeWith(this.taskExecutor);
    }

    public void init() {
        if (this.stateManager.getActiveDatabase().isEmpty()) {
            return;
        }
        this.databaseContext = this.stateManager.getActiveDatabase().get();
        boolean confirm = this.dialogService.showConfirmationDialogAndWait(Localization.lang("Rebuild fulltext search index", new Object[0]), Localization.lang("Rebuild fulltext search index for current library?", new Object[0]));
        if (!confirm) {
            this.shouldContinue = false;
            return;
        }
        this.dialogService.notify(Localization.lang("Rebuilding fulltext search index...", new Object[0]));
    }

    private void rebuildIndex() {
        if (!this.shouldContinue || this.stateManager.getActiveDatabase().isEmpty()) {
            return;
        }
        try {
            PdfIndexer indexer = PdfIndexerManager.getIndexer(this.databaseContext, this.filePreferences);
            this.currentLibraryTab.get().getIndexingTaskManager().rebuildIndex(indexer);
        }
        catch (IOException e) {
            this.dialogService.notify(Localization.lang("Failed to access fulltext search index", new Object[0]));
            LOGGER.error("Failed to access fulltext search index", (Throwable)e);
        }
    }

    public static interface GetCurrentLibraryTab {
        public LibraryTab get();
    }
}

