/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.push;

import java.io.IOException;
import java.util.List;
import org.jabref.gui.DialogService;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.icon.JabRefIcon;
import org.jabref.gui.push.AbstractPushToApplication;
import org.jabref.gui.util.StreamGobbler;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.HeadlessExecutorService;
import org.jabref.logic.util.OS;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushToTexShop
extends AbstractPushToApplication {
    public static final String NAME = "TeXShop";
    private static final Logger LOGGER = LoggerFactory.getLogger(PushToTexShop.class);

    public PushToTexShop(DialogService dialogService, PreferencesService preferencesService) {
        super(dialogService, preferencesService);
    }

    @Override
    public String getDisplayName() {
        return NAME;
    }

    @Override
    public JabRefIcon getApplicationIcon() {
        return IconTheme.JabRefIcons.APPLICATION_TEXSHOP;
    }

    @Override
    public void pushEntries(BibDatabaseContext database, List<BibEntry> entries, String keyString) {
        this.couldNotPush = false;
        this.couldNotCall = false;
        this.notDefined = false;
        this.commandPath = (String)this.preferencesService.getPushToApplicationPreferences().getCommandPaths().get((Object)this.getDisplayName());
        try {
            LOGGER.debug("TexShop string: {}", (Object)String.join((CharSequence)" ", this.getCommandLine(keyString)));
            ProcessBuilder processBuilder = new ProcessBuilder(this.getCommandLine(keyString));
            processBuilder.inheritIO();
            Process process = processBuilder.start();
            StreamGobbler streamGobblerInput = new StreamGobbler(process.getInputStream(), arg_0 -> ((Logger)LOGGER).info(arg_0));
            StreamGobbler streamGobblerError = new StreamGobbler(process.getErrorStream(), arg_0 -> ((Logger)LOGGER).info(arg_0));
            HeadlessExecutorService.INSTANCE.execute(streamGobblerInput);
            HeadlessExecutorService.INSTANCE.execute(streamGobblerError);
        }
        catch (IOException excep) {
            LOGGER.warn("Error: Could not call executable '{}'", (Object)this.commandPath, (Object)excep);
            this.couldNotCall = true;
        }
    }

    @Override
    protected String[] getCommandLine(String keyString) {
        String citeCommand = this.getCitePrefix();
        int intSlashPosition = this.getCitePrefix().indexOf("\\");
        if (intSlashPosition != -1) {
            StringBuilder sb = new StringBuilder(this.getCitePrefix());
            sb.insert(intSlashPosition, "\\");
            citeCommand = sb.toString();
        }
        String osascriptTexShop = "osascript -e 'tell application \"TeXShop\"\nactivate\nset TheString to \"" + citeCommand + keyString + this.getCiteSuffix() + "\"\nset content of selection of front document to TheString\nend tell'";
        if (OS.OS_X) {
            return new String[]{"sh", "-c", osascriptTexShop};
        }
        this.dialogService.showInformationDialogAndWait(Localization.lang("Push to application", new Object[0]), Localization.lang("Pushing citations to TeXShop is only possible on macOS!", new Object[0]));
        return new String[0];
    }
}

