/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.push;

import java.util.HashMap;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import org.jabref.gui.DialogService;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.push.AbstractPushToApplication;
import org.jabref.gui.push.PushToApplication;
import org.jabref.gui.util.FileDialogConfiguration;
import org.jabref.logic.l10n.Localization;
import org.jabref.preferences.FilePreferences;
import org.jabref.preferences.PushToApplicationPreferences;

public class PushToApplicationSettings {
    protected final Label commandLabel;
    protected final TextField path;
    protected final GridPane settingsPane;
    protected final PushToApplicationPreferences preferences;
    protected final AbstractPushToApplication application;

    public PushToApplicationSettings(PushToApplication application, DialogService dialogService, FilePreferences filePreferences, PushToApplicationPreferences preferences) {
        this.application = (AbstractPushToApplication)application;
        this.preferences = preferences;
        this.settingsPane = new GridPane();
        this.commandLabel = new Label();
        this.path = new TextField();
        Button browse = new Button();
        this.settingsPane.setHgap(4.0);
        this.settingsPane.setVgap(4.0);
        browse.setTooltip(new Tooltip(Localization.lang("Browse", new Object[0])));
        browse.setGraphic(IconTheme.JabRefIcons.OPEN.getGraphicNode());
        browse.getStyleClass().addAll((Object[])new String[]{"icon-button", "narrow"});
        browse.setPrefHeight(20.0);
        browse.setPrefWidth(20.0);
        StringBuilder commandLine = new StringBuilder(Localization.lang("Path to %0", application.getDisplayName()));
        if (this.application.getCommandName() == null) {
            commandLine.append(':');
        } else {
            commandLine.append(" (").append(this.application.getCommandName()).append("):");
        }
        this.commandLabel.setText(commandLine.toString());
        this.settingsPane.add((Node)this.commandLabel, 0, 0);
        this.path.setText((String)preferences.getCommandPaths().get((Object)this.application.getDisplayName()));
        this.settingsPane.add((Node)this.path, 1, 0);
        FileDialogConfiguration fileDialogConfiguration = new FileDialogConfiguration.Builder().withInitialDirectory(filePreferences.getWorkingDirectory()).build();
        browse.setOnAction(e -> dialogService.showFileOpenDialog(fileDialogConfiguration).ifPresent(f -> this.path.setText(f.toAbsolutePath().toString())));
        this.settingsPane.add((Node)browse, 2, 0);
        ColumnConstraints textConstraints = new ColumnConstraints();
        ColumnConstraints pathConstraints = new ColumnConstraints();
        pathConstraints.setHgrow(Priority.ALWAYS);
        ColumnConstraints browseConstraints = new ColumnConstraints(20.0);
        browseConstraints.setHgrow(Priority.NEVER);
        this.settingsPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{textConstraints, pathConstraints, browseConstraints});
    }

    public void storeSettings() {
        HashMap<String, String> commandPaths = new HashMap<String, String>((Map<String, String>)this.preferences.getCommandPaths());
        commandPaths.put(this.application.getDisplayName(), this.path.getText());
        this.preferences.setCommandPaths(commandPaths);
    }

    public GridPane getSettingsPane() {
        return this.settingsPane;
    }
}

