/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.push;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.jabref.gui.DialogService;
import org.jabref.gui.actions.Action;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.icon.JabRefIcon;
import org.jabref.gui.keyboard.KeyBinding;
import org.jabref.gui.push.PushToApplication;
import org.jabref.gui.push.PushToApplicationSettings;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.OS;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.strings.StringUtil;
import org.jabref.preferences.PreferencesService;
import org.jabref.preferences.PushToApplicationPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPushToApplication
implements PushToApplication {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPushToApplication.class);
    protected boolean couldNotCall;
    protected boolean couldNotPush;
    protected boolean notDefined;
    protected String commandPath;
    protected final DialogService dialogService;
    protected final PreferencesService preferencesService;

    public AbstractPushToApplication(DialogService dialogService, PreferencesService preferencesService) {
        this.dialogService = dialogService;
        this.preferencesService = preferencesService;
    }

    @Override
    public JabRefIcon getApplicationIcon() {
        return IconTheme.JabRefIcons.APPLICATION_GENERIC;
    }

    @Override
    public String getTooltip() {
        return Localization.lang("Push entries to external application (%0)", this.getDisplayName());
    }

    @Override
    public Action getAction() {
        return new PushToApplicationAction();
    }

    @Override
    public void pushEntries(BibDatabaseContext database, List<BibEntry> entries, String keyString) {
        this.pushEntries(database, entries, keyString, new ProcessBuilder(new String[0]));
    }

    @VisibleForTesting
    protected void pushEntries(BibDatabaseContext database, List<BibEntry> entries, String keyString, ProcessBuilder processBuilder) {
        this.couldNotPush = false;
        this.couldNotCall = false;
        this.notDefined = false;
        this.commandPath = (String)this.preferencesService.getPushToApplicationPreferences().getCommandPaths().get((Object)this.getDisplayName());
        if (StringUtil.isNullOrEmpty(this.commandPath)) {
            this.notDefined = true;
            return;
        }
        try {
            if (OS.OS_X) {
                String[] commands = this.getCommandLine(keyString);
                if (commands.length < 3) {
                    LOGGER.error("Commandline does not contain enough parameters to \"push to application\"");
                    return;
                }
                processBuilder.command("open", "-a", commands[0], "-n", "--args", commands[1], commands[2]);
                processBuilder.start();
            } else {
                processBuilder.command(this.getCommandLine(keyString));
                processBuilder.start();
            }
        }
        catch (IOException excep) {
            LOGGER.warn("Error: Could not call executable '{}'", (Object)this.commandPath, (Object)excep);
            this.couldNotCall = true;
        }
    }

    @Override
    public void onOperationCompleted() {
        if (this.notDefined) {
            this.dialogService.showErrorDialogAndWait(Localization.lang("Error pushing entries", new Object[0]), Localization.lang("Path to %0 not defined", this.getDisplayName()) + ".");
        } else if (this.couldNotCall) {
            this.dialogService.showErrorDialogAndWait(Localization.lang("Error pushing entries", new Object[0]), Localization.lang("Could not call executable", new Object[0]) + " '" + this.commandPath + "'.");
        } else if (this.couldNotPush) {
            this.dialogService.showErrorDialogAndWait(Localization.lang("Error pushing entries", new Object[0]), Localization.lang("Could not connect to %0", this.getDisplayName()) + ".");
        } else {
            this.dialogService.notify(Localization.lang("Pushed citations to %0", this.getDisplayName()) + ".");
        }
    }

    @Override
    public boolean requiresCitationKeys() {
        return true;
    }

    protected String[] getCommandLine(String keyString) {
        return new String[0];
    }

    protected String getCommandName() {
        return null;
    }

    protected String getCitePrefix() {
        return this.preferencesService.getExternalApplicationsPreferences().getCiteCommand().prefix();
    }

    @Override
    public String getDelimiter() {
        return this.preferencesService.getExternalApplicationsPreferences().getCiteCommand().delimiter();
    }

    protected String getCiteSuffix() {
        return this.preferencesService.getExternalApplicationsPreferences().getCiteCommand().suffix();
    }

    @Override
    public PushToApplicationSettings getSettings(PushToApplication application, PushToApplicationPreferences preferences) {
        return new PushToApplicationSettings(application, this.dialogService, this.preferencesService.getFilePreferences(), preferences);
    }

    protected class PushToApplicationAction
    implements Action {
        protected PushToApplicationAction() {
        }

        @Override
        public String getText() {
            return Localization.lang("Push entries to external application (%0)", AbstractPushToApplication.this.getDisplayName());
        }

        @Override
        public Optional<JabRefIcon> getIcon() {
            return Optional.of(AbstractPushToApplication.this.getApplicationIcon());
        }

        @Override
        public Optional<KeyBinding> getKeyBinding() {
            return Optional.of(KeyBinding.PUSH_TO_APPLICATION);
        }
    }
}

