/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preview;

import com.airhacks.afterburner.injection.Injector;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.scene.input.ClipboardContent;
import org.jabref.gui.ClipBoardManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.ActionHelper;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.util.BackgroundTask;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.citationstyle.CitationStyleGenerator;
import org.jabref.logic.citationstyle.CitationStyleOutputFormat;
import org.jabref.logic.citationstyle.CitationStylePreviewLayout;
import org.jabref.logic.journals.JournalAbbreviationRepository;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.layout.Layout;
import org.jabref.logic.layout.LayoutHelper;
import org.jabref.logic.layout.TextBasedPreviewLayout;
import org.jabref.logic.preview.PreviewLayout;
import org.jabref.logic.util.OS;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyCitationAction
extends SimpleCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(CopyCitationAction.class);
    private final List<BibEntry> selectedEntries;
    private final CitationStyleOutputFormat outputFormat;
    private final StateManager stateManager;
    private final DialogService dialogService;
    private final ClipBoardManager clipBoardManager;
    private final TaskExecutor taskExecutor;
    private final PreferencesService preferencesService;
    private final JournalAbbreviationRepository abbreviationRepository;

    public CopyCitationAction(CitationStyleOutputFormat outputFormat, DialogService dialogService, StateManager stateManager, ClipBoardManager clipBoardManager, TaskExecutor taskExecutor, PreferencesService preferencesService, JournalAbbreviationRepository abbreviationRepository) {
        this.outputFormat = outputFormat;
        this.dialogService = dialogService;
        this.stateManager = stateManager;
        this.selectedEntries = stateManager.getSelectedEntries();
        this.clipBoardManager = clipBoardManager;
        this.taskExecutor = taskExecutor;
        this.preferencesService = preferencesService;
        this.abbreviationRepository = abbreviationRepository;
        this.executable.bind((ObservableValue)ActionHelper.needsEntriesSelected(stateManager));
    }

    public void execute() {
        BackgroundTask.wrap(this::generateCitations).onFailure(ex -> LOGGER.error("Error while copying citations to the clipboard", (Throwable)ex)).onSuccess(this::setClipBoardContent).executeWith(this.taskExecutor);
    }

    private List<String> generateCitations() throws IOException {
        String styleSource = null;
        PreviewLayout previewLayout = this.preferencesService.getPreviewPreferences().getSelectedPreviewLayout();
        if (previewLayout instanceof CitationStylePreviewLayout) {
            CitationStylePreviewLayout citationStyleLayout = (CitationStylePreviewLayout)previewLayout;
            styleSource = citationStyleLayout.getText();
        }
        if (styleSource != null) {
            return CitationStyleGenerator.generateCitations(this.selectedEntries, styleSource, this.outputFormat, this.stateManager.getActiveDatabase().get(), (BibEntryTypesManager)Injector.instantiateModelOrService(BibEntryTypesManager.class));
        }
        return this.generateTextBasedPreviewLayoutCitations();
    }

    private List<String> generateTextBasedPreviewLayoutCitations() throws IOException {
        if (this.stateManager.getActiveDatabase().isEmpty()) {
            return Collections.emptyList();
        }
        TextBasedPreviewLayout customPreviewLayout = this.preferencesService.getPreviewPreferences().getCustomPreviewLayout();
        StringReader customLayoutReader = new StringReader(customPreviewLayout.getText().replace("__NEWLINE__", "\n"));
        Layout layout = new LayoutHelper(customLayoutReader, this.preferencesService.getLayoutFormatterPreferences(), this.abbreviationRepository).getLayoutFromText();
        ArrayList<String> citations = new ArrayList<String>(this.selectedEntries.size());
        for (BibEntry entry : this.selectedEntries) {
            citations.add(layout.doLayout(entry, this.stateManager.getActiveDatabase().get().getDatabase()));
        }
        return citations;
    }

    protected static ClipboardContent processPreview(List<String> citations) {
        ClipboardContent content = new ClipboardContent();
        content.putHtml(String.join((CharSequence)CitationStyleOutputFormat.HTML.getLineSeparator(), citations));
        content.putString(String.join((CharSequence)CitationStyleOutputFormat.HTML.getLineSeparator(), citations));
        return content;
    }

    protected static ClipboardContent processText(List<String> citations) {
        ClipboardContent content = new ClipboardContent();
        content.putString(String.join((CharSequence)CitationStyleOutputFormat.TEXT.getLineSeparator(), citations));
        return content;
    }

    protected static ClipboardContent processHtml(List<String> citations) {
        String result = "<!DOCTYPE html>" + OS.NEWLINE + "<html>" + OS.NEWLINE + "   <head>" + OS.NEWLINE + "      <meta charset=\"utf-8\">" + OS.NEWLINE + "   </head>" + OS.NEWLINE + "   <body>" + OS.NEWLINE + OS.NEWLINE;
        result = result + String.join((CharSequence)CitationStyleOutputFormat.HTML.getLineSeparator(), citations);
        result = result + OS.NEWLINE + "   </body>" + OS.NEWLINE + "</html>" + OS.NEWLINE;
        ClipboardContent content = new ClipboardContent();
        content.putString(result);
        content.putHtml(result);
        return content;
    }

    private void setClipBoardContent(List<String> citations) {
        PreviewLayout previewLayout = this.preferencesService.getPreviewPreferences().getSelectedPreviewLayout();
        if (!(previewLayout instanceof CitationStylePreviewLayout)) {
            this.clipBoardManager.setContent(CopyCitationAction.processPreview(citations));
        } else {
            this.clipBoardManager.setContent(switch (this.outputFormat) {
                case CitationStyleOutputFormat.HTML -> CopyCitationAction.processHtml(citations);
                case CitationStyleOutputFormat.TEXT -> CopyCitationAction.processText(citations);
                default -> {
                    LOGGER.warn("unknown output format: '" + String.valueOf((Object)this.outputFormat) + "', processing it via the default.");
                    yield CopyCitationAction.processText(citations);
                }
            });
        }
        this.dialogService.notify(Localization.lang("Copied %0 citations.", String.valueOf(this.selectedEntries.size())));
    }
}

