/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preferences.xmp;

import com.airhacks.afterburner.views.ViewLoader;
import de.saxsys.mvvmfx.utils.validation.visualization.ControlsFxVisualizer;
import jakarta.inject.Inject;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javax.swing.undo.UndoManager;
import org.controlsfx.validation.decoration.ValidationDecoration;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.preferences.AbstractPreferenceTabView;
import org.jabref.gui.preferences.PreferencesTab;
import org.jabref.gui.preferences.xmp.XmpPrivacyTabViewModel;
import org.jabref.gui.util.BindingsHelper;
import org.jabref.gui.util.FieldsUtil;
import org.jabref.gui.util.IconValidationDecorator;
import org.jabref.gui.util.ValueTableCellFactory;
import org.jabref.gui.util.ViewModelListCellFactory;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.field.Field;
import org.jabref.preferences.PreferencesService;

public class XmpPrivacyTab
extends AbstractPreferenceTabView<XmpPrivacyTabViewModel>
implements PreferencesTab {
    @FXML
    private CheckBox enableXmpFilter;
    @FXML
    private TableView<Field> filterList;
    @FXML
    private TableColumn<Field, Field> fieldColumn;
    @FXML
    private TableColumn<Field, Field> actionsColumn;
    @FXML
    private ComboBox<Field> addFieldName;
    @FXML
    private Button addField;
    @Inject
    private PreferencesService preferencesService;
    @Inject
    private UndoManager undoManager;
    private final ControlsFxVisualizer validationVisualizer = new ControlsFxVisualizer();

    public XmpPrivacyTab() {
        ViewLoader.view((Object)this).root((Object)this).load();
    }

    @Override
    public String getTabName() {
        return Localization.lang("XMP metadata", new Object[0]);
    }

    public void initialize() {
        this.viewModel = new XmpPrivacyTabViewModel(this.dialogService, this.preferencesService.getXmpPreferences());
        this.enableXmpFilter.selectedProperty().bindBidirectional((Property)((XmpPrivacyTabViewModel)this.viewModel).xmpFilterEnabledProperty());
        this.filterList.disableProperty().bind((ObservableValue)((XmpPrivacyTabViewModel)this.viewModel).xmpFilterEnabledProperty().not());
        this.addFieldName.disableProperty().bind((ObservableValue)((XmpPrivacyTabViewModel)this.viewModel).xmpFilterEnabledProperty().not());
        this.addField.disableProperty().bind((ObservableValue)((XmpPrivacyTabViewModel)this.viewModel).xmpFilterEnabledProperty().not());
        this.fieldColumn.setSortable(true);
        this.fieldColumn.setReorderable(false);
        this.fieldColumn.setCellValueFactory(cellData -> BindingsHelper.constantOf((Field)cellData.getValue()));
        new ValueTableCellFactory().withText(item -> FieldsUtil.getNameWithType(item, this.preferencesService, this.undoManager)).install(this.fieldColumn);
        this.actionsColumn.setSortable(false);
        this.actionsColumn.setReorderable(false);
        this.actionsColumn.setCellValueFactory(cellData -> BindingsHelper.constantOf((Field)cellData.getValue()));
        new ValueTableCellFactory().withGraphic(item -> IconTheme.JabRefIcons.DELETE_ENTRY.getGraphicNode()).withTooltip(item -> Localization.lang("Remove", new Object[0]) + " " + item.getName()).withOnMouseClickedEvent(item -> evt -> ((XmpPrivacyTabViewModel)this.viewModel).removeFilter((Field)this.filterList.getFocusModel().getFocusedItem())).install(this.actionsColumn);
        this.filterList.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode() == KeyCode.DELETE) {
                ((XmpPrivacyTabViewModel)this.viewModel).removeFilter((Field)this.filterList.getSelectionModel().getSelectedItem());
                event.consume();
            }
        });
        this.filterList.itemsProperty().bind(((XmpPrivacyTabViewModel)this.viewModel).filterListProperty());
        this.addFieldName.setEditable(true);
        new ViewModelListCellFactory().withText(item -> FieldsUtil.getNameWithType(item, this.preferencesService, this.undoManager)).install(this.addFieldName);
        this.addFieldName.itemsProperty().bind(((XmpPrivacyTabViewModel)this.viewModel).availableFieldsProperty());
        this.addFieldName.valueProperty().bindBidirectional(((XmpPrivacyTabViewModel)this.viewModel).addFieldNameProperty());
        this.addFieldName.setConverter(FieldsUtil.FIELD_STRING_CONVERTER);
        this.addFieldName.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode() == KeyCode.ENTER) {
                ((XmpPrivacyTabViewModel)this.viewModel).addField();
                event.consume();
            }
        });
        this.validationVisualizer.setDecoration((ValidationDecoration)new IconValidationDecorator());
        Platform.runLater(() -> this.validationVisualizer.initVisualization(((XmpPrivacyTabViewModel)this.viewModel).xmpFilterListValidationStatus(), this.filterList));
    }

    public void addField() {
        ((XmpPrivacyTabViewModel)this.viewModel).addField();
    }
}

