/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preferences.websearch;

import com.airhacks.afterburner.views.ViewLoader;
import com.tobiasdiez.easybind.EasyBind;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.input.MouseButton;
import org.jabref.gui.preferences.AbstractPreferenceTabView;
import org.jabref.gui.preferences.PreferencesTab;
import org.jabref.gui.preferences.websearch.WebSearchTabViewModel;
import org.jabref.gui.slr.StudyCatalogItem;
import org.jabref.gui.util.ViewModelTableRowFactory;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.preferences.FetcherApiKey;

public class WebSearchTab
extends AbstractPreferenceTabView<WebSearchTabViewModel>
implements PreferencesTab {
    @FXML
    private CheckBox enableWebSearch;
    @FXML
    private CheckBox generateNewKeyOnImport;
    @FXML
    private CheckBox warnAboutDuplicatesOnImport;
    @FXML
    private CheckBox downloadLinkedOnlineFiles;
    @FXML
    private CheckBox useCustomDOI;
    @FXML
    private TextField useCustomDOIName;
    @FXML
    private CheckBox grobidEnabled;
    @FXML
    private TextField grobidURL;
    @FXML
    private TableView<FetcherApiKey> apiKeySelectorTable;
    @FXML
    private TableColumn<FetcherApiKey, String> apiKeyName;
    @FXML
    private TableColumn<FetcherApiKey, String> customApiKey;
    @FXML
    private TableColumn<FetcherApiKey, Boolean> useCustomApiKey;
    @FXML
    private Button testCustomApiKey;
    @FXML
    private CheckBox persistApiKeys;
    @FXML
    private SplitPane persistentTooltipWrapper;
    @FXML
    private TableView<StudyCatalogItem> catalogTable;
    @FXML
    private TableColumn<StudyCatalogItem, Boolean> catalogEnabledColumn;
    @FXML
    private TableColumn<StudyCatalogItem, String> catalogColumn;

    public WebSearchTab() {
        ViewLoader.view((Object)this).root((Object)this).load();
    }

    @Override
    public String getTabName() {
        return Localization.lang("Web search", new Object[0]);
    }

    public void initialize() {
        this.viewModel = new WebSearchTabViewModel(this.preferencesService, this.dialogService);
        this.enableWebSearch.selectedProperty().bindBidirectional((Property)((WebSearchTabViewModel)this.viewModel).enableWebSearchProperty());
        this.generateNewKeyOnImport.selectedProperty().bindBidirectional((Property)((WebSearchTabViewModel)this.viewModel).generateKeyOnImportProperty());
        this.warnAboutDuplicatesOnImport.selectedProperty().bindBidirectional((Property)((WebSearchTabViewModel)this.viewModel).warnAboutDuplicatesOnImportProperty());
        this.downloadLinkedOnlineFiles.selectedProperty().bindBidirectional((Property)((WebSearchTabViewModel)this.viewModel).shouldDownloadLinkedOnlineFiles());
        this.grobidEnabled.selectedProperty().bindBidirectional((Property)((WebSearchTabViewModel)this.viewModel).grobidEnabledProperty());
        this.grobidURL.textProperty().bindBidirectional((Property)((WebSearchTabViewModel)this.viewModel).grobidURLProperty());
        this.grobidURL.disableProperty().bind((ObservableValue)this.grobidEnabled.selectedProperty().not());
        this.useCustomDOI.selectedProperty().bindBidirectional((Property)((WebSearchTabViewModel)this.viewModel).useCustomDOIProperty());
        this.useCustomDOIName.textProperty().bindBidirectional((Property)((WebSearchTabViewModel)this.viewModel).useCustomDOINameProperty());
        this.useCustomDOIName.disableProperty().bind((ObservableValue)this.useCustomDOI.selectedProperty().not());
        new ViewModelTableRowFactory<StudyCatalogItem>().withOnMouseClickedEvent((entry, event) -> {
            if (event.getButton() == MouseButton.PRIMARY) {
                entry.setEnabled(!entry.isEnabled());
            }
        }).install(this.catalogTable);
        this.catalogColumn.setReorderable(false);
        this.catalogColumn.setCellFactory(TextFieldTableCell.forTableColumn());
        this.catalogEnabledColumn.setResizable(false);
        this.catalogEnabledColumn.setReorderable(false);
        this.catalogEnabledColumn.setCellFactory(CheckBoxTableCell.forTableColumn(this.catalogEnabledColumn));
        this.catalogEnabledColumn.setCellValueFactory(param -> ((StudyCatalogItem)param.getValue()).enabledProperty());
        this.catalogColumn.setEditable(false);
        this.catalogColumn.setCellValueFactory(param -> ((StudyCatalogItem)param.getValue()).nameProperty());
        this.catalogTable.setItems(((WebSearchTabViewModel)this.viewModel).getCatalogs());
        this.testCustomApiKey.setDisable(true);
        new ViewModelTableRowFactory<FetcherApiKey>().install(this.apiKeySelectorTable);
        this.apiKeySelectorTable.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue != null) {
                this.updateFetcherApiKey((FetcherApiKey)oldValue);
            }
            if (newValue != null) {
                ((WebSearchTabViewModel)this.viewModel).selectedApiKeyProperty().setValue(newValue);
                this.testCustomApiKey.disableProperty().bind((ObservableValue)newValue.useProperty().not());
            }
        });
        this.apiKeyName.setCellValueFactory(param -> ((FetcherApiKey)param.getValue()).nameProperty());
        this.apiKeyName.setCellFactory(TextFieldTableCell.forTableColumn());
        this.apiKeyName.setReorderable(false);
        this.apiKeyName.setEditable(false);
        this.customApiKey.setCellValueFactory(param -> ((FetcherApiKey)param.getValue()).keyProperty());
        this.customApiKey.setCellFactory(TextFieldTableCell.forTableColumn());
        this.customApiKey.setReorderable(false);
        this.customApiKey.setResizable(true);
        this.customApiKey.setEditable(true);
        this.useCustomApiKey.setCellValueFactory(param -> ((FetcherApiKey)param.getValue()).useProperty());
        this.useCustomApiKey.setCellFactory(CheckBoxTableCell.forTableColumn(this.useCustomApiKey));
        this.useCustomApiKey.setEditable(true);
        this.useCustomApiKey.setResizable(true);
        this.useCustomApiKey.setReorderable(false);
        this.persistApiKeys.selectedProperty().bindBidirectional((Property)((WebSearchTabViewModel)this.viewModel).getApikeyPersistProperty());
        this.persistApiKeys.disableProperty().bind((ObservableValue)((WebSearchTabViewModel)this.viewModel).apiKeyPersistAvailable().not());
        EasyBind.subscribe((ObservableValue)((WebSearchTabViewModel)this.viewModel).apiKeyPersistAvailable(), available -> {
            if (!available.booleanValue()) {
                this.persistentTooltipWrapper.setTooltip(new Tooltip(Localization.lang("Credential store not available.", new Object[0])));
            } else {
                this.persistentTooltipWrapper.setTooltip(null);
            }
        });
        this.apiKeySelectorTable.setItems(((WebSearchTabViewModel)this.viewModel).fetcherApiKeys());
        ((WebSearchTabViewModel)this.viewModel).fetcherApiKeys().addListener(change -> {
            if (!this.apiKeySelectorTable.getItems().isEmpty()) {
                this.apiKeySelectorTable.getSelectionModel().selectFirst();
            }
        });
    }

    private void updateFetcherApiKey(FetcherApiKey apiKey) {
        if (apiKey != null) {
            apiKey.setKey(((String)this.customApiKey.getCellData((Object)apiKey)).trim());
        }
    }

    @FXML
    void checkCustomApiKey() {
        ((WebSearchTabViewModel)this.viewModel).checkCustomApiKey();
    }
}

