/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preferences.table;

import com.airhacks.afterburner.views.ViewLoader;
import de.saxsys.mvvmfx.utils.commands.Command;
import de.saxsys.mvvmfx.utils.validation.visualization.ControlsFxVisualizer;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.controlsfx.validation.decoration.ValidationDecoration;
import org.jabref.gui.actions.ActionFactory;
import org.jabref.gui.actions.StandardActions;
import org.jabref.gui.help.HelpAction;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.maintable.MainTableColumnModel;
import org.jabref.gui.preferences.AbstractPreferenceTabView;
import org.jabref.gui.preferences.PreferencesTab;
import org.jabref.gui.preferences.table.TableTabViewModel;
import org.jabref.gui.util.IconValidationDecorator;
import org.jabref.gui.util.ValueTableCellFactory;
import org.jabref.gui.util.ViewModelListCellFactory;
import org.jabref.logic.help.HelpFile;
import org.jabref.logic.l10n.Localization;

public class TableTab
extends AbstractPreferenceTabView<TableTabViewModel>
implements PreferencesTab {
    @FXML
    private TableView<MainTableColumnModel> columnsList;
    @FXML
    private TableColumn<MainTableColumnModel, String> nameColumn;
    @FXML
    private TableColumn<MainTableColumnModel, String> actionsColumn;
    @FXML
    private ComboBox<MainTableColumnModel> addColumnName;
    @FXML
    private CheckBox specialFieldsEnable;
    @FXML
    private Button specialFieldsHelp;
    @FXML
    private CheckBox extraFileColumnsEnable;
    @FXML
    private CheckBox autoResizeColumns;
    @FXML
    private RadioButton namesNatbib;
    @FXML
    private RadioButton nameAsIs;
    @FXML
    private RadioButton nameFirstLast;
    @FXML
    private RadioButton nameLastFirst;
    @FXML
    private RadioButton abbreviationDisabled;
    @FXML
    private RadioButton abbreviationEnabled;
    @FXML
    private RadioButton abbreviationLastNameOnly;
    private final ControlsFxVisualizer validationVisualizer = new ControlsFxVisualizer();

    public TableTab() {
        ViewLoader.view((Object)this).root((Object)this).load();
    }

    @Override
    public String getTabName() {
        return Localization.lang("Entry table", new Object[0]);
    }

    public void initialize() {
        this.viewModel = new TableTabViewModel(this.dialogService, this.preferencesService);
        this.setupTable();
        this.setupBindings();
        ActionFactory actionFactory = new ActionFactory();
        actionFactory.configureIconButton(StandardActions.HELP_SPECIAL_FIELDS, (Command)new HelpAction(HelpFile.SPECIAL_FIELDS, this.dialogService, this.preferencesService.getFilePreferences()), (ButtonBase)this.specialFieldsHelp);
    }

    private void setupTable() {
        this.nameColumn.setSortable(false);
        this.nameColumn.setReorderable(false);
        this.nameColumn.setCellValueFactory(cellData -> ((MainTableColumnModel)cellData.getValue()).nameProperty());
        new ValueTableCellFactory().withText(name -> name).install(this.nameColumn);
        this.actionsColumn.setSortable(false);
        this.actionsColumn.setReorderable(false);
        this.actionsColumn.setCellValueFactory(cellData -> ((MainTableColumnModel)cellData.getValue()).nameProperty());
        new ValueTableCellFactory().withGraphic(item -> IconTheme.JabRefIcons.DELETE_ENTRY.getGraphicNode()).withTooltip(name -> Localization.lang("Remove column", new Object[0]) + " " + name).withOnMouseClickedEvent(item -> evt -> ((TableTabViewModel)this.viewModel).removeColumn((MainTableColumnModel)this.columnsList.getFocusModel().getFocusedItem())).install(this.actionsColumn);
        ((TableTabViewModel)this.viewModel).selectedColumnModelProperty().setValue((Object)this.columnsList.getSelectionModel());
        this.columnsList.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode() == KeyCode.DELETE) {
                ((TableTabViewModel)this.viewModel).removeColumn((MainTableColumnModel)this.columnsList.getSelectionModel().getSelectedItem());
                event.consume();
            }
        });
        this.columnsList.itemsProperty().bind(((TableTabViewModel)this.viewModel).columnsListProperty());
        new ViewModelListCellFactory().withText(MainTableColumnModel::getDisplayName).install(this.addColumnName);
        this.addColumnName.itemsProperty().bind(((TableTabViewModel)this.viewModel).availableColumnsProperty());
        this.addColumnName.valueProperty().bindBidirectional(((TableTabViewModel)this.viewModel).addColumnProperty());
        this.addColumnName.setConverter(TableTabViewModel.columnNameStringConverter);
        this.addColumnName.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode() == KeyCode.ENTER) {
                ((TableTabViewModel)this.viewModel).insertColumnInList();
                event.consume();
            }
        });
        this.validationVisualizer.setDecoration((ValidationDecoration)new IconValidationDecorator());
        Platform.runLater(() -> this.validationVisualizer.initVisualization(((TableTabViewModel)this.viewModel).columnsListValidationStatus(), this.columnsList));
    }

    private void setupBindings() {
        this.specialFieldsEnable.selectedProperty().bindBidirectional((Property)((TableTabViewModel)this.viewModel).specialFieldsEnabledProperty());
        this.extraFileColumnsEnable.selectedProperty().bindBidirectional((Property)((TableTabViewModel)this.viewModel).extraFileColumnsEnabledProperty());
        this.autoResizeColumns.selectedProperty().bindBidirectional((Property)((TableTabViewModel)this.viewModel).autoResizeColumnsProperty());
        this.namesNatbib.selectedProperty().bindBidirectional((Property)((TableTabViewModel)this.viewModel).namesNatbibProperty());
        this.nameAsIs.selectedProperty().bindBidirectional((Property)((TableTabViewModel)this.viewModel).nameAsIsProperty());
        this.nameFirstLast.selectedProperty().bindBidirectional((Property)((TableTabViewModel)this.viewModel).nameFirstLastProperty());
        this.nameLastFirst.selectedProperty().bindBidirectional((Property)((TableTabViewModel)this.viewModel).nameLastFirstProperty());
        this.abbreviationDisabled.selectedProperty().bindBidirectional((Property)((TableTabViewModel)this.viewModel).abbreviationDisabledProperty());
        this.abbreviationDisabled.disableProperty().bind((ObservableValue)this.namesNatbib.selectedProperty().or((ObservableBooleanValue)this.nameAsIs.selectedProperty()));
        this.abbreviationEnabled.selectedProperty().bindBidirectional((Property)((TableTabViewModel)this.viewModel).abbreviationEnabledProperty());
        this.abbreviationEnabled.disableProperty().bind((ObservableValue)this.namesNatbib.selectedProperty().or((ObservableBooleanValue)this.nameAsIs.selectedProperty()));
        this.abbreviationLastNameOnly.selectedProperty().bindBidirectional((Property)((TableTabViewModel)this.viewModel).abbreviationLastNameOnlyProperty());
        this.abbreviationLastNameOnly.disableProperty().bind((ObservableValue)this.namesNatbib.selectedProperty().or((ObservableBooleanValue)this.nameAsIs.selectedProperty()));
    }

    public void updateToCurrentColumnOrder() {
        ((TableTabViewModel)this.viewModel).fillColumnList();
    }

    public void sortColumnUp() {
        ((TableTabViewModel)this.viewModel).moveColumnUp();
    }

    public void sortColumnDown() {
        ((TableTabViewModel)this.viewModel).moveColumnDown();
    }

    public void addColumn() {
        ((TableTabViewModel)this.viewModel).insertColumnInList();
    }
}

