/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preferences.keybindings;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.input.KeyEvent;
import org.jabref.gui.DialogService;
import org.jabref.gui.keyboard.KeyBinding;
import org.jabref.gui.keyboard.KeyBindingCategory;
import org.jabref.gui.keyboard.KeyBindingRepository;
import org.jabref.gui.preferences.PreferenceTabViewModel;
import org.jabref.gui.preferences.keybindings.KeyBindingViewModel;
import org.jabref.gui.preferences.keybindings.presets.BashKeyBindingPreset;
import org.jabref.gui.preferences.keybindings.presets.KeyBindingPreset;
import org.jabref.gui.preferences.keybindings.presets.NewEntryBindingPreset;
import org.jabref.gui.util.OptionalObjectProperty;
import org.jabref.logic.l10n.Localization;
import org.jabref.preferences.PreferencesService;

public class KeyBindingsTabViewModel
implements PreferenceTabViewModel {
    private final KeyBindingRepository keyBindingRepository;
    private final PreferencesService preferences;
    private final OptionalObjectProperty<KeyBindingViewModel> selectedKeyBinding = OptionalObjectProperty.empty();
    private final ObjectProperty<KeyBindingViewModel> rootKeyBinding = new SimpleObjectProperty();
    private final ListProperty<KeyBindingPreset> keyBindingPresets = new SimpleListProperty(FXCollections.observableArrayList());
    private final DialogService dialogService;
    private final List<String> restartWarning = new ArrayList<String>();

    public KeyBindingsTabViewModel(KeyBindingRepository keyBindingRepository, DialogService dialogService, PreferencesService preferences) {
        this.keyBindingRepository = new KeyBindingRepository(keyBindingRepository.getKeyBindings());
        this.dialogService = Objects.requireNonNull(dialogService);
        this.preferences = Objects.requireNonNull(preferences);
        this.keyBindingPresets.add((Object)new BashKeyBindingPreset());
        this.keyBindingPresets.add((Object)new NewEntryBindingPreset());
    }

    @Override
    public void setValues() {
        KeyBindingViewModel root = new KeyBindingViewModel(this.keyBindingRepository, KeyBindingCategory.FILE);
        for (KeyBindingCategory category : KeyBindingCategory.values()) {
            KeyBindingViewModel categoryItem = new KeyBindingViewModel(this.keyBindingRepository, category);
            this.keyBindingRepository.getKeyBindings().forEach((keyBinding, bind) -> {
                if (keyBinding.getCategory() == category) {
                    KeyBindingViewModel keyBindViewModel = new KeyBindingViewModel(this.keyBindingRepository, (KeyBinding)((Object)keyBinding), (String)bind);
                    categoryItem.getChildren().add((Object)keyBindViewModel);
                }
            });
            root.getChildren().add((Object)categoryItem);
        }
        this.rootKeyBinding.set((Object)root);
    }

    public void setNewBindingForCurrent(KeyEvent event) {
        Optional selectedKeyBindingValue = (Optional)this.selectedKeyBinding.getValue();
        if (selectedKeyBindingValue.isEmpty()) {
            return;
        }
        KeyBindingViewModel selectedEntry = (KeyBindingViewModel)selectedKeyBindingValue.get();
        if (selectedEntry.isCategory()) {
            return;
        }
        if (selectedEntry.setNewBinding(event)) {
            this.keyBindingRepository.put(selectedEntry.getKeyBinding(), selectedEntry.getBinding());
        }
    }

    @Override
    public void storeSettings() {
        if (!this.keyBindingRepository.equals(this.preferences.getKeyBindingRepository())) {
            this.preferences.getKeyBindingRepository().getBindingsProperty().set(this.keyBindingRepository.getBindingsProperty());
            this.restartWarning.add(Localization.lang("Keyboard shortcuts changed", new Object[0]));
        }
    }

    public void resetToDefault() {
        String title = Localization.lang("Resetting all keyboard shortcuts", new Object[0]);
        String content = Localization.lang("All keyboard shortcuts will be reset to their defaults.", new Object[0]);
        ButtonType resetButtonType = new ButtonType("Reset", ButtonBar.ButtonData.OK_DONE);
        this.dialogService.showCustomButtonDialogAndWait(Alert.AlertType.INFORMATION, title, content, resetButtonType, ButtonType.CANCEL).ifPresent(response -> {
            if (response == resetButtonType) {
                this.keyBindingRepository.resetToDefault();
                this.setValues();
            }
        });
    }

    public void loadPreset(KeyBindingPreset preset) {
        if (preset == null) {
            return;
        }
        preset.getKeyBindings().forEach(this.keyBindingRepository::put);
        this.setValues();
    }

    public ListProperty<KeyBindingPreset> keyBindingPresets() {
        return this.keyBindingPresets;
    }

    @Override
    public List<String> getRestartWarnings() {
        return this.restartWarning;
    }

    public OptionalObjectProperty<KeyBindingViewModel> selectedKeyBindingProperty() {
        return this.selectedKeyBinding;
    }

    public ObjectProperty<KeyBindingViewModel> rootKeyBindingProperty() {
        return this.rootKeyBinding;
    }

    public KeyBindingRepository getKeyBindingRepository() {
        return this.keyBindingRepository;
    }
}

