/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preferences.journals;

import com.airhacks.afterburner.injection.Injector;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.jabref.gui.DialogService;
import org.jabref.gui.preferences.PreferenceTabViewModel;
import org.jabref.gui.preferences.journals.AbbreviationViewModel;
import org.jabref.gui.preferences.journals.AbbreviationsFileViewModel;
import org.jabref.gui.util.BackgroundTask;
import org.jabref.gui.util.FileDialogConfiguration;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.journals.Abbreviation;
import org.jabref.logic.journals.JournalAbbreviationLoader;
import org.jabref.logic.journals.JournalAbbreviationPreferences;
import org.jabref.logic.journals.JournalAbbreviationRepository;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.StandardFileType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JournalAbbreviationsTabViewModel
implements PreferenceTabViewModel {
    private final Logger LOGGER = LoggerFactory.getLogger(JournalAbbreviationsTabViewModel.class);
    private final SimpleListProperty<AbbreviationsFileViewModel> journalFiles = new SimpleListProperty(FXCollections.observableArrayList());
    private final SimpleListProperty<AbbreviationViewModel> abbreviations = new SimpleListProperty(FXCollections.observableArrayList());
    private final SimpleIntegerProperty abbreviationsCount = new SimpleIntegerProperty();
    private final SimpleObjectProperty<AbbreviationsFileViewModel> currentFile = new SimpleObjectProperty();
    private final SimpleObjectProperty<AbbreviationViewModel> currentAbbreviation = new SimpleObjectProperty();
    private final SimpleBooleanProperty isFileRemovable = new SimpleBooleanProperty();
    private final SimpleBooleanProperty isLoading = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty isEditableAndRemovable = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty isAbbreviationEditableAndRemovable = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty useFJournal = new SimpleBooleanProperty(true);
    private final DialogService dialogService;
    private final TaskExecutor taskExecutor;
    private final JournalAbbreviationPreferences abbreviationsPreferences;
    private final JournalAbbreviationRepository journalAbbreviationRepository;
    private boolean shouldWriteLists;

    public JournalAbbreviationsTabViewModel(JournalAbbreviationPreferences abbreviationsPreferences, DialogService dialogService, TaskExecutor taskExecutor, JournalAbbreviationRepository journalAbbreviationRepository) {
        this.dialogService = Objects.requireNonNull(dialogService);
        this.taskExecutor = Objects.requireNonNull(taskExecutor);
        this.journalAbbreviationRepository = Objects.requireNonNull(journalAbbreviationRepository);
        this.abbreviationsPreferences = abbreviationsPreferences;
        this.abbreviationsCount.bind((ObservableValue)this.abbreviations.sizeProperty());
        this.currentAbbreviation.addListener((observable, oldValue, newValue) -> {
            boolean isAbbreviation = newValue != null && !newValue.isPseudoAbbreviation();
            boolean isEditableFile = this.currentFile.get() != null && !((AbbreviationsFileViewModel)this.currentFile.get()).isBuiltInListProperty().get();
            this.isEditableAndRemovable.set(isEditableFile);
            this.isAbbreviationEditableAndRemovable.set(isAbbreviation && isEditableFile);
        });
        this.currentFile.addListener((observable, oldValue, newValue) -> {
            if (oldValue != null) {
                this.abbreviations.unbindBidirectional(oldValue.abbreviationsProperty());
                this.currentAbbreviation.set(null);
            }
            if (newValue != null) {
                this.isFileRemovable.set(!newValue.isBuiltInListProperty().get());
                this.abbreviations.bindBidirectional(newValue.abbreviationsProperty());
                if (!this.abbreviations.isEmpty()) {
                    this.currentAbbreviation.set((Object)((AbbreviationViewModel)this.abbreviations.getLast()));
                }
            } else {
                this.isFileRemovable.set(false);
                if (this.journalFiles.isEmpty()) {
                    this.currentAbbreviation.set(null);
                    this.abbreviations.clear();
                } else {
                    this.currentFile.set((Object)((AbbreviationsFileViewModel)this.journalFiles.getFirst()));
                }
            }
        });
        this.journalFiles.addListener(lcl -> {
            if (lcl.next() && !lcl.wasReplaced() && lcl.wasAdded() && !((AbbreviationsFileViewModel)lcl.getAddedSubList().getFirst()).isBuiltInListProperty().get()) {
                this.currentFile.set((Object)((AbbreviationsFileViewModel)lcl.getAddedSubList().getFirst()));
            }
        });
    }

    @Override
    public void setValues() {
        this.journalFiles.clear();
        this.createFileObjects();
        this.selectLastJournalFile();
        this.addBuiltInList();
    }

    public void createFileObjects() {
        ObservableList<String> externalFiles = this.abbreviationsPreferences.getExternalJournalLists();
        externalFiles.forEach(name -> this.openFile(Path.of(name, new String[0])));
    }

    public void selectLastJournalFile() {
        if (!this.journalFiles.isEmpty()) {
            this.currentFile.set((Object)((AbbreviationsFileViewModel)this.journalFilesProperty().get(this.journalFilesProperty().size() - 1)));
        }
    }

    public void addBuiltInList() {
        BackgroundTask.wrap(this.journalAbbreviationRepository::getAllLoaded).onRunning(() -> this.isLoading.setValue(Boolean.valueOf(true))).onSuccess(result -> {
            this.isLoading.setValue(Boolean.valueOf(false));
            List<AbbreviationViewModel> builtInViewModels = result.stream().map(AbbreviationViewModel::new).collect(Collectors.toList());
            this.journalFiles.add((Object)new AbbreviationsFileViewModel(builtInViewModels, Localization.lang("JabRef built in list", new Object[0])));
            this.selectLastJournalFile();
        }).onFailure(this.dialogService::showErrorDialogAndWait).executeWith(this.taskExecutor);
    }

    public void addNewFile() {
        FileDialogConfiguration fileDialogConfiguration = new FileDialogConfiguration.Builder().addExtensionFilter(StandardFileType.CSV).build();
        this.dialogService.showFileSaveDialog(fileDialogConfiguration).ifPresent(this::openFile);
    }

    private void openFile(Path filePath) {
        AbbreviationsFileViewModel abbreviationsFile = new AbbreviationsFileViewModel(filePath);
        if (this.journalFiles.contains((Object)abbreviationsFile)) {
            this.dialogService.showErrorDialogAndWait(Localization.lang("Duplicated Journal File", new Object[0]), Localization.lang("Journal file %s already added", filePath.toString()));
            return;
        }
        if (abbreviationsFile.exists()) {
            try {
                abbreviationsFile.readAbbreviations();
            }
            catch (IOException e) {
                this.LOGGER.debug("Could not read abbreviations file", (Throwable)e);
            }
        }
        this.journalFiles.add((Object)abbreviationsFile);
    }

    public void openFile() {
        FileDialogConfiguration fileDialogConfiguration = new FileDialogConfiguration.Builder().addExtensionFilter(StandardFileType.CSV).build();
        this.dialogService.showFileOpenDialog(fileDialogConfiguration).ifPresent(this::openFile);
    }

    public void removeCurrentFile() {
        if (this.isFileRemovable.get()) {
            this.journalFiles.remove(this.currentFile.get());
            if (this.journalFiles.isEmpty()) {
                this.currentFile.set(null);
            }
        }
    }

    public void addAbbreviation(Abbreviation abbreviationObject) {
        AbbreviationViewModel abbreviationViewModel = new AbbreviationViewModel(abbreviationObject);
        if (this.abbreviations.contains((Object)abbreviationViewModel)) {
            this.dialogService.showErrorDialogAndWait(Localization.lang("Duplicated Journal Abbreviation", new Object[0]), Localization.lang("Abbreviation '%0' for journal '%1' already defined.", abbreviationObject.getAbbreviation(), abbreviationObject.getName()));
        } else {
            this.abbreviations.add((Object)abbreviationViewModel);
            this.currentAbbreviation.set((Object)abbreviationViewModel);
            this.shouldWriteLists = true;
        }
    }

    public void addAbbreviation() {
        this.addAbbreviation(new Abbreviation(Localization.lang("Name", new Object[0]), Localization.lang("Abbreviation", new Object[0]), Localization.lang("Shortest unique abbreviation", new Object[0])));
    }

    void editAbbreviation(Abbreviation abbreviationObject) {
        if (this.isEditableAndRemovable.get()) {
            AbbreviationViewModel abbViewModel = new AbbreviationViewModel(abbreviationObject);
            if (this.abbreviations.contains((Object)abbViewModel)) {
                if (abbViewModel.equals(this.currentAbbreviation.get())) {
                    this.setCurrentAbbreviationNameAndAbbreviationIfValid(abbreviationObject);
                } else {
                    this.dialogService.showErrorDialogAndWait(Localization.lang("Duplicated Journal Abbreviation", new Object[0]), Localization.lang("Abbreviation '%0' for journal '%1' already defined.", abbreviationObject.getAbbreviation(), abbreviationObject.getName()));
                }
            } else {
                this.setCurrentAbbreviationNameAndAbbreviationIfValid(abbreviationObject);
            }
        }
    }

    private void setCurrentAbbreviationNameAndAbbreviationIfValid(Abbreviation abbreviationObject) {
        if (abbreviationObject.getName().trim().isEmpty()) {
            this.dialogService.showErrorDialogAndWait(Localization.lang("Name cannot be empty", new Object[0]));
            return;
        }
        if (abbreviationObject.getAbbreviation().trim().isEmpty()) {
            this.dialogService.showErrorDialogAndWait(Localization.lang("Abbreviation cannot be empty", new Object[0]));
            return;
        }
        AbbreviationViewModel abbreviationViewModel = (AbbreviationViewModel)this.currentAbbreviation.get();
        abbreviationViewModel.setName(abbreviationObject.getName());
        abbreviationViewModel.setAbbreviation(abbreviationObject.getAbbreviation());
        if (abbreviationObject.isDefaultShortestUniqueAbbreviation()) {
            abbreviationViewModel.setShortestUniqueAbbreviation("");
        } else {
            abbreviationViewModel.setShortestUniqueAbbreviation(abbreviationObject.getShortestUniqueAbbreviation());
        }
        this.shouldWriteLists = true;
    }

    public void deleteAbbreviation() {
        if (this.currentAbbreviation.get() != null && !((AbbreviationViewModel)this.currentAbbreviation.get()).isPseudoAbbreviation()) {
            int index = this.abbreviations.indexOf(this.currentAbbreviation.get());
            if (index > 1) {
                this.currentAbbreviation.set((Object)((AbbreviationViewModel)this.abbreviations.get(index - 1)));
            } else if (index + 1 < this.abbreviationsCount.get()) {
                this.currentAbbreviation.set((Object)((AbbreviationViewModel)this.abbreviations.get(index + 1)));
            } else {
                this.currentAbbreviation.set(null);
            }
            this.abbreviations.remove(index);
            this.shouldWriteLists = true;
        }
    }

    public void removeAbbreviation(AbbreviationViewModel abbreviation) {
        Objects.requireNonNull(abbreviation);
        if (abbreviation.isPseudoAbbreviation()) {
            return;
        }
        this.abbreviations.remove((Object)abbreviation);
        this.shouldWriteLists = true;
    }

    public void saveJournalAbbreviationFiles() {
        this.journalFiles.forEach(file -> {
            try {
                file.writeOrCreate();
            }
            catch (IOException e) {
                this.LOGGER.debug("Error during writing journal CSV", (Throwable)e);
            }
        });
    }

    @Override
    public void storeSettings() {
        BackgroundTask.wrap(() -> {
            List<String> journalStringList = this.journalFiles.stream().filter(path -> !path.isBuiltInListProperty().get()).filter(path -> path.getAbsolutePath().isPresent()).map(path -> path.getAbsolutePath().get().toAbsolutePath().toString()).collect(Collectors.toList());
            this.abbreviationsPreferences.setExternalJournalLists(journalStringList);
            this.abbreviationsPreferences.setUseFJournalField(this.useFJournal.get());
            if (this.shouldWriteLists) {
                this.saveJournalAbbreviationFiles();
                this.shouldWriteLists = false;
            }
        }).onSuccess(success -> Injector.setModelOrService(JournalAbbreviationRepository.class, (Object)JournalAbbreviationLoader.loadRepository(this.abbreviationsPreferences))).onFailure(exception -> this.LOGGER.error("Failed to store journal preferences.", (Throwable)exception)).executeWith(this.taskExecutor);
    }

    public SimpleBooleanProperty isLoadingProperty() {
        return this.isLoading;
    }

    public SimpleListProperty<AbbreviationsFileViewModel> journalFilesProperty() {
        return this.journalFiles;
    }

    public SimpleListProperty<AbbreviationViewModel> abbreviationsProperty() {
        return this.abbreviations;
    }

    public SimpleIntegerProperty abbreviationsCountProperty() {
        return this.abbreviationsCount;
    }

    public SimpleObjectProperty<AbbreviationsFileViewModel> currentFileProperty() {
        return this.currentFile;
    }

    public SimpleObjectProperty<AbbreviationViewModel> currentAbbreviationProperty() {
        return this.currentAbbreviation;
    }

    public SimpleBooleanProperty isEditableAndRemovableProperty() {
        return this.isEditableAndRemovable;
    }

    public SimpleBooleanProperty isAbbreviationEditableAndRemovable() {
        return this.isAbbreviationEditableAndRemovable;
    }

    public SimpleBooleanProperty isFileRemovableProperty() {
        return this.isFileRemovable;
    }

    public SimpleBooleanProperty useFJournalProperty() {
        return this.useFJournal;
    }
}

