/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preferences.journals;

import com.airhacks.afterburner.views.ViewLoader;
import com.tobiasdiez.easybind.EasyBind;
import jakarta.inject.Inject;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.transformation.FilteredList;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.paint.Color;
import javafx.util.Duration;
import org.controlsfx.control.textfield.CustomTextField;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.preferences.AbstractPreferenceTabView;
import org.jabref.gui.preferences.PreferencesTab;
import org.jabref.gui.preferences.journals.AbbreviationViewModel;
import org.jabref.gui.preferences.journals.AbbreviationsFileViewModel;
import org.jabref.gui.preferences.journals.JournalAbbreviationsTabViewModel;
import org.jabref.gui.util.ColorUtil;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.gui.util.ValueTableCellFactory;
import org.jabref.logic.journals.JournalAbbreviationRepository;
import org.jabref.logic.l10n.Localization;

public class JournalAbbreviationsTab
extends AbstractPreferenceTabView<JournalAbbreviationsTabViewModel>
implements PreferencesTab {
    @FXML
    private Label loadingLabel;
    @FXML
    private ProgressIndicator progressIndicator;
    @FXML
    private TableView<AbbreviationViewModel> journalAbbreviationsTable;
    @FXML
    private TableColumn<AbbreviationViewModel, String> journalTableNameColumn;
    @FXML
    private TableColumn<AbbreviationViewModel, String> journalTableAbbreviationColumn;
    @FXML
    private TableColumn<AbbreviationViewModel, String> journalTableShortestUniqueAbbreviationColumn;
    @FXML
    private TableColumn<AbbreviationViewModel, String> actionsColumn;
    private FilteredList<AbbreviationViewModel> filteredAbbreviations;
    @FXML
    private ComboBox<AbbreviationsFileViewModel> journalFilesBox;
    @FXML
    private Button addAbbreviationButton;
    @FXML
    private Button removeAbbreviationListButton;
    @FXML
    private CustomTextField searchBox;
    @FXML
    private CheckBox useFJournal;
    @Inject
    private TaskExecutor taskExecutor;
    @Inject
    private JournalAbbreviationRepository abbreviationRepository;
    private Timeline invalidateSearch;

    public JournalAbbreviationsTab() {
        ViewLoader.view((Object)this).root((Object)this).load();
    }

    @FXML
    private void initialize() {
        this.viewModel = new JournalAbbreviationsTabViewModel(this.preferencesService.getJournalAbbreviationPreferences(), this.dialogService, this.taskExecutor, this.abbreviationRepository);
        this.filteredAbbreviations = new FilteredList(((JournalAbbreviationsTabViewModel)this.viewModel).abbreviationsProperty());
        this.setUpTable();
        this.setBindings();
        this.setAnimations();
        this.searchBox.setPromptText(Localization.lang("Search", new Object[0]) + "...");
        this.searchBox.setLeft(IconTheme.JabRefIcons.SEARCH.getGraphicNode());
    }

    private void setUpTable() {
        this.journalTableNameColumn.setCellValueFactory(cellData -> ((AbbreviationViewModel)cellData.getValue()).nameProperty());
        this.journalTableNameColumn.setCellFactory(TextFieldTableCell.forTableColumn());
        this.journalTableAbbreviationColumn.setCellValueFactory(cellData -> ((AbbreviationViewModel)cellData.getValue()).abbreviationProperty());
        this.journalTableAbbreviationColumn.setCellFactory(TextFieldTableCell.forTableColumn());
        this.journalTableShortestUniqueAbbreviationColumn.setCellValueFactory(cellData -> ((AbbreviationViewModel)cellData.getValue()).shortestUniqueAbbreviationProperty());
        this.journalTableShortestUniqueAbbreviationColumn.setCellFactory(TextFieldTableCell.forTableColumn());
        this.actionsColumn.setCellValueFactory(cellData -> ((AbbreviationViewModel)cellData.getValue()).nameProperty());
        new ValueTableCellFactory().withGraphic(name -> IconTheme.JabRefIcons.DELETE_ENTRY.getGraphicNode()).withTooltip(name -> Localization.lang("Remove journal '%0'", name)).withDisableExpression(item -> ((JournalAbbreviationsTabViewModel)this.viewModel).isEditableAndRemovableProperty().not()).withVisibleExpression(item -> ((JournalAbbreviationsTabViewModel)this.viewModel).isEditableAndRemovableProperty()).withOnMouseClickedEvent(item -> evt -> ((JournalAbbreviationsTabViewModel)this.viewModel).removeAbbreviation((AbbreviationViewModel)this.journalAbbreviationsTable.getFocusModel().getFocusedItem())).install(this.actionsColumn);
    }

    private void setBindings() {
        this.journalAbbreviationsTable.setItems(this.filteredAbbreviations);
        EasyBind.subscribe((ObservableValue)this.journalAbbreviationsTable.getSelectionModel().selectedItemProperty(), newValue -> ((JournalAbbreviationsTabViewModel)this.viewModel).currentAbbreviationProperty().set(newValue));
        EasyBind.subscribe(((JournalAbbreviationsTabViewModel)this.viewModel).currentAbbreviationProperty(), newValue -> this.journalAbbreviationsTable.getSelectionModel().select(newValue));
        this.journalTableNameColumn.editableProperty().bind((ObservableValue)((JournalAbbreviationsTabViewModel)this.viewModel).isAbbreviationEditableAndRemovable());
        this.journalTableAbbreviationColumn.editableProperty().bind((ObservableValue)((JournalAbbreviationsTabViewModel)this.viewModel).isAbbreviationEditableAndRemovable());
        this.journalTableShortestUniqueAbbreviationColumn.editableProperty().bind((ObservableValue)((JournalAbbreviationsTabViewModel)this.viewModel).isAbbreviationEditableAndRemovable());
        this.removeAbbreviationListButton.disableProperty().bind((ObservableValue)((JournalAbbreviationsTabViewModel)this.viewModel).isFileRemovableProperty().not());
        this.journalFilesBox.itemsProperty().bindBidirectional(((JournalAbbreviationsTabViewModel)this.viewModel).journalFilesProperty());
        this.journalFilesBox.valueProperty().bindBidirectional(((JournalAbbreviationsTabViewModel)this.viewModel).currentFileProperty());
        this.addAbbreviationButton.disableProperty().bind((ObservableValue)((JournalAbbreviationsTabViewModel)this.viewModel).isEditableAndRemovableProperty().not());
        this.loadingLabel.visibleProperty().bind((ObservableValue)((JournalAbbreviationsTabViewModel)this.viewModel).isLoadingProperty());
        this.progressIndicator.visibleProperty().bind((ObservableValue)((JournalAbbreviationsTabViewModel)this.viewModel).isLoadingProperty());
        this.searchBox.textProperty().addListener((observable, previousText, searchTerm) -> this.filteredAbbreviations.setPredicate(abbreviation -> searchTerm.isEmpty() || abbreviation.containsCaseIndependent((String)searchTerm)));
        this.useFJournal.selectedProperty().bindBidirectional((Property)((JournalAbbreviationsTabViewModel)this.viewModel).useFJournalProperty());
    }

    private void setAnimations() {
        SimpleObjectProperty flashingColor = new SimpleObjectProperty((Object)Color.TRANSPARENT);
        StringProperty flashingColorStringProperty = JournalAbbreviationsTab.createFlashingColorStringProperty((ObjectProperty<Color>)flashingColor);
        this.searchBox.styleProperty().bind((ObservableValue)new SimpleStringProperty("-fx-control-inner-background: ").concat((Object)flashingColorStringProperty).concat((Object)";"));
        this.invalidateSearch = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)0.0), new KeyValue[]{new KeyValue((WritableValue)flashingColor, (Object)Color.TRANSPARENT, Interpolator.LINEAR)}), new KeyFrame(Duration.seconds((double)0.25), new KeyValue[]{new KeyValue((WritableValue)flashingColor, (Object)Color.RED, Interpolator.LINEAR)}), new KeyFrame(Duration.seconds((double)0.25), new KeyValue[]{new KeyValue((WritableValue)this.searchBox.textProperty(), (Object)"", Interpolator.DISCRETE)}), new KeyFrame(Duration.seconds((double)0.25), event -> this.addAbbreviationActions(), new KeyValue[0]), new KeyFrame(Duration.seconds((double)0.5), new KeyValue[]{new KeyValue((WritableValue)flashingColor, (Object)Color.TRANSPARENT, Interpolator.LINEAR)})});
    }

    @FXML
    private void addList() {
        ((JournalAbbreviationsTabViewModel)this.viewModel).addNewFile();
    }

    @FXML
    private void openList() {
        ((JournalAbbreviationsTabViewModel)this.viewModel).openFile();
    }

    @FXML
    private void removeList() {
        ((JournalAbbreviationsTabViewModel)this.viewModel).removeCurrentFile();
    }

    @FXML
    private void addAbbreviation() {
        if (!this.searchBox.getText().isEmpty()) {
            this.invalidateSearch.play();
        } else {
            this.addAbbreviationActions();
        }
    }

    private void addAbbreviationActions() {
        ((JournalAbbreviationsTabViewModel)this.viewModel).addAbbreviation();
        this.selectNewAbbreviation();
        this.editAbbreviation();
    }

    private static StringProperty createFlashingColorStringProperty(ObjectProperty<Color> flashingColor) {
        SimpleStringProperty flashingColorStringProperty = new SimpleStringProperty();
        JournalAbbreviationsTab.setColorStringFromColor((StringProperty)flashingColorStringProperty, flashingColor);
        flashingColor.addListener((arg_0, arg_1, arg_2) -> JournalAbbreviationsTab.lambda$createFlashingColorStringProperty$15((StringProperty)flashingColorStringProperty, flashingColor, arg_0, arg_1, arg_2));
        return flashingColorStringProperty;
    }

    private static void setColorStringFromColor(StringProperty colorStringProperty, ObjectProperty<Color> color) {
        colorStringProperty.set((Object)ColorUtil.toRGBACode((Color)color.get()));
    }

    @FXML
    private void editAbbreviation() {
        this.journalAbbreviationsTable.edit(this.journalAbbreviationsTable.getSelectionModel().getSelectedIndex(), this.journalTableNameColumn);
    }

    private void selectNewAbbreviation() {
        int lastRow = ((JournalAbbreviationsTabViewModel)this.viewModel).abbreviationsCountProperty().get() - 1;
        this.journalAbbreviationsTable.scrollTo(lastRow);
        this.journalAbbreviationsTable.getSelectionModel().select(lastRow);
        this.journalAbbreviationsTable.getFocusModel().focus(lastRow, this.journalTableNameColumn);
    }

    @Override
    public String getTabName() {
        return Localization.lang("Journal abbreviations", new Object[0]);
    }

    private static /* synthetic */ void lambda$createFlashingColorStringProperty$15(StringProperty flashingColorStringProperty, ObjectProperty flashingColor, ObservableValue observable, Color oldValue, Color newValue) {
        JournalAbbreviationsTab.setColorStringFromColor(flashingColorStringProperty, (ObjectProperty<Color>)flashingColor);
    }
}

