/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preferences.groups;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import org.jabref.gui.groups.GroupViewMode;
import org.jabref.gui.groups.GroupsPreferences;
import org.jabref.gui.preferences.PreferenceTabViewModel;

public class GroupsTabViewModel
implements PreferenceTabViewModel {
    private final BooleanProperty groupViewModeIntersectionProperty = new SimpleBooleanProperty();
    private final BooleanProperty groupViewModeUnionProperty = new SimpleBooleanProperty();
    private final BooleanProperty autoAssignGroupProperty = new SimpleBooleanProperty();
    private final BooleanProperty displayGroupCountProperty = new SimpleBooleanProperty();
    private final GroupsPreferences groupsPreferences;

    public GroupsTabViewModel(GroupsPreferences groupsPreferences) {
        this.groupsPreferences = groupsPreferences;
    }

    @Override
    public void setValues() {
        switch (this.groupsPreferences.getGroupViewMode()) {
            case INTERSECTION: {
                this.groupViewModeIntersectionProperty.setValue(Boolean.valueOf(true));
                this.groupViewModeUnionProperty.setValue(Boolean.valueOf(false));
                break;
            }
            case UNION: {
                this.groupViewModeIntersectionProperty.setValue(Boolean.valueOf(false));
                this.groupViewModeUnionProperty.setValue(Boolean.valueOf(true));
            }
        }
        this.autoAssignGroupProperty.setValue(Boolean.valueOf(this.groupsPreferences.shouldAutoAssignGroup()));
        this.displayGroupCountProperty.setValue(Boolean.valueOf(this.groupsPreferences.shouldDisplayGroupCount()));
    }

    @Override
    public void storeSettings() {
        this.groupsPreferences.setGroupViewMode(this.groupViewModeIntersectionProperty.getValue() != false ? GroupViewMode.INTERSECTION : GroupViewMode.UNION);
        this.groupsPreferences.setAutoAssignGroup(this.autoAssignGroupProperty.getValue());
        this.groupsPreferences.setDisplayGroupCount(this.displayGroupCountProperty.getValue());
    }

    public BooleanProperty groupViewModeIntersectionProperty() {
        return this.groupViewModeIntersectionProperty;
    }

    public BooleanProperty groupViewModeUnionProperty() {
        return this.groupViewModeUnionProperty;
    }

    public BooleanProperty autoAssignGroupProperty() {
        return this.autoAssignGroupProperty;
    }

    public BooleanProperty displayGroupCount() {
        return this.displayGroupCountProperty;
    }
}

