/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preferences.externalfiletypes;

import com.airhacks.afterburner.views.ViewLoader;
import javafx.fxml.FXML;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.icon.JabRefIcon;
import org.jabref.gui.preferences.AbstractPreferenceTabView;
import org.jabref.gui.preferences.PreferencesTab;
import org.jabref.gui.preferences.externalfiletypes.ExternalFileTypeItemViewModel;
import org.jabref.gui.preferences.externalfiletypes.ExternalFileTypesTabViewModel;
import org.jabref.gui.util.BindingsHelper;
import org.jabref.gui.util.ValueTableCellFactory;
import org.jabref.logic.l10n.Localization;

public class ExternalFileTypesTab
extends AbstractPreferenceTabView<ExternalFileTypesTabViewModel>
implements PreferencesTab {
    @FXML
    private TableColumn<ExternalFileTypeItemViewModel, JabRefIcon> fileTypesTableIconColumn;
    @FXML
    private TableColumn<ExternalFileTypeItemViewModel, String> fileTypesTableNameColumn;
    @FXML
    private TableColumn<ExternalFileTypeItemViewModel, String> fileTypesTableExtensionColumn;
    @FXML
    private TableColumn<ExternalFileTypeItemViewModel, String> fileTypesTableMimeTypeColumn;
    @FXML
    private TableColumn<ExternalFileTypeItemViewModel, String> fileTypesTableApplicationColumn;
    @FXML
    private TableColumn<ExternalFileTypeItemViewModel, Boolean> fileTypesTableEditColumn;
    @FXML
    private TableColumn<ExternalFileTypeItemViewModel, Boolean> fileTypesTableDeleteColumn;
    @FXML
    private TableView<ExternalFileTypeItemViewModel> fileTypesTable;

    public ExternalFileTypesTab() {
        ViewLoader.view((Object)this).root((Object)this).load();
    }

    @Override
    public String getTabName() {
        return Localization.lang("External file types", new Object[0]);
    }

    @FXML
    public void initialize() {
        this.viewModel = new ExternalFileTypesTabViewModel(this.preferencesService.getFilePreferences(), this.dialogService);
        this.fileTypesTable.setItems(((ExternalFileTypesTabViewModel)this.viewModel).getFileTypes());
        this.fileTypesTableIconColumn.setCellValueFactory(cellData -> ((ExternalFileTypeItemViewModel)cellData.getValue()).iconProperty());
        new ValueTableCellFactory().withGraphic(JabRefIcon::getGraphicNode).install(this.fileTypesTableIconColumn);
        this.fileTypesTableNameColumn.setCellValueFactory(cellData -> ((ExternalFileTypeItemViewModel)cellData.getValue()).nameProperty());
        new ValueTableCellFactory().withText(name -> name).install(this.fileTypesTableNameColumn);
        this.fileTypesTableExtensionColumn.setCellValueFactory(cellData -> ((ExternalFileTypeItemViewModel)cellData.getValue()).extensionProperty());
        new ValueTableCellFactory().withText(extension -> extension).install(this.fileTypesTableExtensionColumn);
        this.fileTypesTableMimeTypeColumn.setCellValueFactory(cellData -> ((ExternalFileTypeItemViewModel)cellData.getValue()).mimetypeProperty());
        new ValueTableCellFactory().withText(mimetype -> mimetype).install(this.fileTypesTableMimeTypeColumn);
        this.fileTypesTableApplicationColumn.setCellValueFactory(cellData -> ((ExternalFileTypeItemViewModel)cellData.getValue()).applicationProperty());
        new ValueTableCellFactory().withText(extension -> extension).install(this.fileTypesTableApplicationColumn);
        this.fileTypesTableEditColumn.setCellValueFactory(data -> BindingsHelper.constantOf(true));
        this.fileTypesTableDeleteColumn.setCellValueFactory(data -> BindingsHelper.constantOf(true));
        new ValueTableCellFactory().withGraphic(JabRefIcon::getGraphicNode).install(this.fileTypesTableIconColumn);
        new ValueTableCellFactory().withGraphic(none -> IconTheme.JabRefIcons.EDIT.getGraphicNode()).withOnMouseClickedEvent((type, none) -> event -> this.editType((ExternalFileTypeItemViewModel)type)).install(this.fileTypesTableEditColumn);
        new ValueTableCellFactory().withGraphic(none -> IconTheme.JabRefIcons.DELETE_ENTRY.getGraphicNode()).withOnMouseClickedEvent((type, none) -> event -> ((ExternalFileTypesTabViewModel)this.viewModel).remove((ExternalFileTypeItemViewModel)type)).install(this.fileTypesTableDeleteColumn);
    }

    private void editType(ExternalFileTypeItemViewModel type) {
        if (((ExternalFileTypesTabViewModel)this.viewModel).edit(type)) {
            this.fileTypesTable.getSelectionModel().selectLast();
            this.fileTypesTable.scrollTo(((ExternalFileTypesTabViewModel)this.viewModel).getFileTypes().size() - 1);
        }
    }

    @FXML
    private void addNewType() {
        if (((ExternalFileTypesTabViewModel)this.viewModel).addNewType()) {
            this.fileTypesTable.getSelectionModel().selectLast();
            this.fileTypesTable.scrollTo(((ExternalFileTypesTabViewModel)this.viewModel).getFileTypes().size() - 1);
        }
    }

    @FXML
    private void resetToDefault() {
        ((ExternalFileTypesTabViewModel)this.viewModel).resetToDefaults();
    }
}

