/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preferences.external;

import de.saxsys.mvvmfx.utils.validation.CompositeValidator;
import de.saxsys.mvvmfx.utils.validation.FunctionBasedValidator;
import de.saxsys.mvvmfx.utils.validation.ValidationMessage;
import de.saxsys.mvvmfx.utils.validation.ValidationStatus;
import de.saxsys.mvvmfx.utils.validation.Validator;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.DialogPane;
import org.jabref.gui.DialogService;
import org.jabref.gui.preferences.PreferenceTabViewModel;
import org.jabref.gui.push.PushToApplication;
import org.jabref.gui.push.PushToApplicationSettings;
import org.jabref.gui.push.PushToApplications;
import org.jabref.gui.push.PushToEmacs;
import org.jabref.gui.util.FileDialogConfiguration;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.push.CitationCommandString;
import org.jabref.model.strings.StringUtil;
import org.jabref.preferences.ExternalApplicationsPreferences;
import org.jabref.preferences.PreferencesService;
import org.jabref.preferences.PushToApplicationPreferences;

public class ExternalTabViewModel
implements PreferenceTabViewModel {
    private final StringProperty eMailReferenceSubjectProperty = new SimpleStringProperty("");
    private final BooleanProperty autoOpenAttachedFoldersProperty = new SimpleBooleanProperty();
    private final ListProperty<PushToApplication> pushToApplicationsListProperty = new SimpleListProperty();
    private final ObjectProperty<PushToApplication> selectedPushToApplicationProperty = new SimpleObjectProperty();
    private final StringProperty citeCommandProperty = new SimpleStringProperty("");
    private final BooleanProperty useCustomTerminalProperty = new SimpleBooleanProperty();
    private final StringProperty customTerminalCommandProperty = new SimpleStringProperty("");
    private final BooleanProperty useCustomFileBrowserProperty = new SimpleBooleanProperty();
    private final StringProperty customFileBrowserCommandProperty = new SimpleStringProperty("");
    private final StringProperty kindleEmailProperty = new SimpleStringProperty("");
    private final Validator terminalCommandValidator;
    private final Validator fileBrowserCommandValidator;
    private final DialogService dialogService;
    private final PreferencesService preferences;
    private final FileDialogConfiguration fileDialogConfiguration = new FileDialogConfiguration.Builder().build();
    private final ExternalApplicationsPreferences initialExternalApplicationPreferences;
    private final PushToApplicationPreferences initialPushToApplicationPreferences;
    private final PushToApplicationPreferences workingPushToApplicationPreferences;

    public ExternalTabViewModel(DialogService dialogService, PreferencesService preferencesService) {
        this.dialogService = dialogService;
        this.preferences = preferencesService;
        this.initialExternalApplicationPreferences = this.preferences.getExternalApplicationsPreferences();
        this.initialPushToApplicationPreferences = this.preferences.getPushToApplicationPreferences();
        this.workingPushToApplicationPreferences = new PushToApplicationPreferences(this.initialPushToApplicationPreferences.getActiveApplicationName(), new HashMap<String, String>((Map<String, String>)this.initialPushToApplicationPreferences.getCommandPaths()), this.initialPushToApplicationPreferences.getEmacsArguments(), this.initialPushToApplicationPreferences.getVimServer());
        this.terminalCommandValidator = new FunctionBasedValidator((ObservableValue)this.customTerminalCommandProperty, input -> !StringUtil.isNullOrEmpty(input), ValidationMessage.error((String)"%s > %s %n %n %s".formatted(Localization.lang("External programs", new Object[0]), Localization.lang("Custom applications", new Object[0]), Localization.lang("Please specify a terminal application.", new Object[0]))));
        this.fileBrowserCommandValidator = new FunctionBasedValidator((ObservableValue)this.customFileBrowserCommandProperty, input -> !StringUtil.isNullOrEmpty(input), ValidationMessage.error((String)"%s > %s %n %n %s".formatted(Localization.lang("External programs", new Object[0]), Localization.lang("Custom applications", new Object[0]), Localization.lang("Please specify a file browser.", new Object[0]))));
    }

    @Override
    public void setValues() {
        this.eMailReferenceSubjectProperty.setValue(this.initialExternalApplicationPreferences.getEmailSubject());
        this.autoOpenAttachedFoldersProperty.setValue(Boolean.valueOf(this.initialExternalApplicationPreferences.shouldAutoOpenEmailAttachmentsFolder()));
        this.pushToApplicationsListProperty.setValue(FXCollections.observableArrayList(PushToApplications.getAllApplications(this.dialogService, this.preferences)));
        this.selectedPushToApplicationProperty.setValue((Object)PushToApplications.getApplicationByName(this.initialPushToApplicationPreferences.getActiveApplicationName(), this.dialogService, this.preferences).orElse(new PushToEmacs(this.dialogService, this.preferences)));
        this.citeCommandProperty.setValue(this.initialExternalApplicationPreferences.getCiteCommand().toString());
        this.useCustomTerminalProperty.setValue(Boolean.valueOf(this.initialExternalApplicationPreferences.useCustomTerminal()));
        this.customTerminalCommandProperty.setValue(this.initialExternalApplicationPreferences.getCustomTerminalCommand());
        this.useCustomFileBrowserProperty.setValue(Boolean.valueOf(this.initialExternalApplicationPreferences.useCustomFileBrowser()));
        this.customFileBrowserCommandProperty.setValue(this.initialExternalApplicationPreferences.getCustomFileBrowserCommand());
        this.kindleEmailProperty.setValue(this.initialExternalApplicationPreferences.getKindleEmail());
    }

    @Override
    public void storeSettings() {
        ExternalApplicationsPreferences externalPreferences = this.preferences.getExternalApplicationsPreferences();
        externalPreferences.setEMailSubject(this.eMailReferenceSubjectProperty.getValue());
        externalPreferences.setAutoOpenEmailAttachmentsFolder(this.autoOpenAttachedFoldersProperty.getValue());
        externalPreferences.setCiteCommand(CitationCommandString.from(this.citeCommandProperty.getValue()));
        externalPreferences.setUseCustomTerminal(this.useCustomTerminalProperty.getValue());
        externalPreferences.setCustomTerminalCommand(this.customTerminalCommandProperty.getValue());
        externalPreferences.setUseCustomFileBrowser(this.useCustomFileBrowserProperty.getValue());
        externalPreferences.setCustomFileBrowserCommand(this.customFileBrowserCommandProperty.getValue());
        externalPreferences.setKindleEmail(this.kindleEmailProperty.getValue());
        PushToApplicationPreferences pushPreferences = this.preferences.getPushToApplicationPreferences();
        pushPreferences.setActiveApplicationName(((PushToApplication)this.selectedPushToApplicationProperty.getValue()).getDisplayName());
        pushPreferences.setCommandPaths((Map<String, String>)this.workingPushToApplicationPreferences.getCommandPaths());
        pushPreferences.setEmacsArguments(this.workingPushToApplicationPreferences.getEmacsArguments());
        pushPreferences.setVimServer(this.workingPushToApplicationPreferences.getVimServer());
    }

    public ValidationStatus terminalCommandValidationStatus() {
        return this.terminalCommandValidator.getValidationStatus();
    }

    public ValidationStatus fileBrowserCommandValidationStatus() {
        return this.fileBrowserCommandValidator.getValidationStatus();
    }

    @Override
    public boolean validateSettings() {
        ValidationStatus validationStatus;
        CompositeValidator validator = new CompositeValidator();
        if (this.useCustomTerminalProperty.getValue().booleanValue()) {
            validator.addValidators(new Validator[]{this.terminalCommandValidator});
        }
        if (this.useCustomFileBrowserProperty.getValue().booleanValue()) {
            validator.addValidators(new Validator[]{this.fileBrowserCommandValidator});
        }
        if (!(validationStatus = validator.getValidationStatus()).isValid()) {
            validationStatus.getHighestMessage().ifPresent(message -> this.dialogService.showErrorDialogAndWait(message.getMessage()));
            return false;
        }
        return true;
    }

    public void pushToApplicationSettings() {
        PushToApplication selectedApplication = (PushToApplication)this.selectedPushToApplicationProperty.getValue();
        PushToApplicationSettings settings = selectedApplication.getSettings(selectedApplication, this.workingPushToApplicationPreferences);
        DialogPane dialogPane = new DialogPane();
        dialogPane.setContent((Node)settings.getSettingsPane());
        this.dialogService.showCustomDialogAndWait(Localization.lang("Application settings", new Object[0]), dialogPane, ButtonType.OK, ButtonType.CANCEL).ifPresent(btn -> {
            if (btn == ButtonType.OK) {
                settings.storeSettings();
            }
        });
    }

    public void customTerminalBrowse() {
        this.dialogService.showFileOpenDialog(this.fileDialogConfiguration).ifPresent(file -> this.customTerminalCommandProperty.setValue(file.toAbsolutePath().toString()));
    }

    public void customFileBrowserBrowse() {
        this.dialogService.showFileOpenDialog(this.fileDialogConfiguration).ifPresent(file -> this.customFileBrowserCommandProperty.setValue(file.toAbsolutePath().toString()));
    }

    public StringProperty eMailReferenceSubjectProperty() {
        return this.eMailReferenceSubjectProperty;
    }

    public StringProperty kindleEmailProperty() {
        return this.kindleEmailProperty;
    }

    public BooleanProperty autoOpenAttachedFoldersProperty() {
        return this.autoOpenAttachedFoldersProperty;
    }

    public ListProperty<PushToApplication> pushToApplicationsListProperty() {
        return this.pushToApplicationsListProperty;
    }

    public ObjectProperty<PushToApplication> selectedPushToApplication() {
        return this.selectedPushToApplicationProperty;
    }

    public StringProperty citeCommandProperty() {
        return this.citeCommandProperty;
    }

    public BooleanProperty useCustomTerminalProperty() {
        return this.useCustomTerminalProperty;
    }

    public StringProperty customTerminalCommandProperty() {
        return this.customTerminalCommandProperty;
    }

    public BooleanProperty useCustomFileBrowserProperty() {
        return this.useCustomFileBrowserProperty;
    }

    public StringProperty customFileBrowserCommandProperty() {
        return this.customFileBrowserCommandProperty;
    }

    public void resetCiteCommandToDefault() {
        this.citeCommandProperty.setValue(this.preferences.getExternalApplicationsPreferences().getDefaultCiteCommand().toString());
    }
}

