/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preferences.entry;

import com.airhacks.afterburner.views.ViewLoader;
import de.saxsys.mvvmfx.utils.commands.Command;
import java.util.function.UnaryOperator;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import org.jabref.gui.actions.ActionFactory;
import org.jabref.gui.actions.StandardActions;
import org.jabref.gui.help.HelpAction;
import org.jabref.gui.preferences.AbstractPreferenceTabView;
import org.jabref.gui.preferences.PreferencesTab;
import org.jabref.gui.preferences.entry.EntryTabViewModel;
import org.jabref.logic.help.HelpFile;
import org.jabref.logic.l10n.Localization;

public class EntryTab
extends AbstractPreferenceTabView<EntryTabViewModel>
implements PreferencesTab {
    @FXML
    private TextField keywordSeparator;
    @FXML
    private CheckBox resolveStrings;
    @FXML
    private TextField resolveStringsForFields;
    @FXML
    private TextField nonWrappableFields;
    @FXML
    private CheckBox markOwner;
    @FXML
    private TextField markOwnerName;
    @FXML
    private CheckBox markOwnerOverwrite;
    @FXML
    private Button markOwnerHelp;
    @FXML
    private CheckBox addCreationDate;
    @FXML
    private CheckBox addModificationDate;

    public EntryTab() {
        ViewLoader.view((Object)this).root((Object)this).load();
    }

    public void initialize() {
        this.viewModel = new EntryTabViewModel(this.preferencesService);
        this.keywordSeparator.textProperty().bindBidirectional((Property)((EntryTabViewModel)this.viewModel).keywordSeparatorProperty());
        UnaryOperator singleCharacterFilter = change -> {
            if (change.getControlNewText().length() <= 1) {
                return change;
            }
            return null;
        };
        TextFormatter formatter = new TextFormatter(singleCharacterFilter);
        this.keywordSeparator.setTextFormatter(formatter);
        this.resolveStrings.selectedProperty().bindBidirectional((Property)((EntryTabViewModel)this.viewModel).resolveStringsProperty());
        this.resolveStringsForFields.textProperty().bindBidirectional((Property)((EntryTabViewModel)this.viewModel).resolveStringsForFieldsProperty());
        this.nonWrappableFields.textProperty().bindBidirectional((Property)((EntryTabViewModel)this.viewModel).nonWrappableFieldsProperty());
        this.markOwner.selectedProperty().bindBidirectional((Property)((EntryTabViewModel)this.viewModel).markOwnerProperty());
        this.markOwnerName.textProperty().bindBidirectional((Property)((EntryTabViewModel)this.viewModel).markOwnerNameProperty());
        this.markOwnerName.disableProperty().bind((ObservableValue)this.markOwner.selectedProperty().not());
        this.markOwnerOverwrite.selectedProperty().bindBidirectional((Property)((EntryTabViewModel)this.viewModel).markOwnerOverwriteProperty());
        this.markOwnerOverwrite.disableProperty().bind((ObservableValue)this.markOwner.selectedProperty().not());
        this.addCreationDate.selectedProperty().bindBidirectional((Property)((EntryTabViewModel)this.viewModel).addCreationDateProperty());
        this.addModificationDate.selectedProperty().bindBidirectional((Property)((EntryTabViewModel)this.viewModel).addModificationDateProperty());
        ActionFactory actionFactory = new ActionFactory();
        actionFactory.configureIconButton(StandardActions.HELP, (Command)new HelpAction(HelpFile.OWNER, this.dialogService, this.preferencesService.getFilePreferences()), (ButtonBase)this.markOwnerHelp);
    }

    @Override
    public String getTabName() {
        return Localization.lang("Entry", new Object[0]);
    }
}

