/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preferences.customexporter;

import com.airhacks.afterburner.views.ViewLoader;
import com.tobiasdiez.easybind.EasyBind;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import org.jabref.gui.exporter.ExporterViewModel;
import org.jabref.gui.preferences.AbstractPreferenceTabView;
import org.jabref.gui.preferences.PreferencesTab;
import org.jabref.gui.preferences.customexporter.CustomExporterTabViewModel;
import org.jabref.logic.l10n.Localization;

public class CustomExporterTab
extends AbstractPreferenceTabView<CustomExporterTabViewModel>
implements PreferencesTab {
    @FXML
    private TableView<ExporterViewModel> exporterTable;
    @FXML
    private TableColumn<ExporterViewModel, String> nameColumn;
    @FXML
    private TableColumn<ExporterViewModel, String> layoutColumn;
    @FXML
    private TableColumn<ExporterViewModel, String> extensionColumn;

    public CustomExporterTab() {
        ViewLoader.view((Object)this).root((Object)this).load();
    }

    @Override
    public String getTabName() {
        return Localization.lang("Custom export formats", new Object[0]);
    }

    @FXML
    private void initialize() {
        this.viewModel = new CustomExporterTabViewModel(this.preferencesService, this.dialogService);
        this.exporterTable.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.exporterTable.itemsProperty().bind(((CustomExporterTabViewModel)this.viewModel).exportersProperty());
        EasyBind.bindContent(((CustomExporterTabViewModel)this.viewModel).selectedExportersProperty(), (ObservableList)this.exporterTable.getSelectionModel().getSelectedItems());
        this.nameColumn.setCellValueFactory(cellData -> ((ExporterViewModel)cellData.getValue()).name());
        this.layoutColumn.setCellValueFactory(cellData -> ((ExporterViewModel)cellData.getValue()).layoutFileName());
        this.extensionColumn.setCellValueFactory(cellData -> ((ExporterViewModel)cellData.getValue()).extension());
    }

    @FXML
    private void add() {
        ((CustomExporterTabViewModel)this.viewModel).addExporter();
    }

    @FXML
    private void modify() {
        ((CustomExporterTabViewModel)this.viewModel).modifyExporter();
    }

    @FXML
    private void remove() {
        ((CustomExporterTabViewModel)this.viewModel).removeExporters();
    }
}

