/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.openoffice;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.DialogPane;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextArea;
import org.jabref.gui.DialogService;
import org.jabref.gui.desktop.JabRefDesktop;
import org.jabref.gui.externalfiletype.ExternalFileType;
import org.jabref.gui.externalfiletype.ExternalFileTypes;
import org.jabref.gui.openoffice.StyleSelectItemViewModel;
import org.jabref.gui.util.FileDialogConfiguration;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.openoffice.OpenOfficePreferences;
import org.jabref.logic.openoffice.style.OOBibStyle;
import org.jabref.logic.openoffice.style.StyleLoader;
import org.jabref.logic.util.FileType;
import org.jabref.logic.util.StandardFileType;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.preferences.FilePreferences;
import org.jabref.preferences.PreferencesService;

public class StyleSelectDialogViewModel {
    private final DialogService dialogService;
    private final StyleLoader styleLoader;
    private final OpenOfficePreferences openOfficePreferences;
    private final FilePreferences filePreferences;
    private final ListProperty<StyleSelectItemViewModel> styles = new SimpleListProperty(FXCollections.observableArrayList());
    private final ObjectProperty<StyleSelectItemViewModel> selectedItem = new SimpleObjectProperty();

    public StyleSelectDialogViewModel(DialogService dialogService, StyleLoader styleLoader, PreferencesService preferencesService) {
        this.dialogService = dialogService;
        this.filePreferences = preferencesService.getFilePreferences();
        this.openOfficePreferences = preferencesService.getOpenOfficePreferences();
        this.styleLoader = styleLoader;
        this.styles.addAll(this.loadStyles());
        String currentStyle = this.openOfficePreferences.getCurrentStyle();
        this.selectedItem.setValue((Object)this.getStyleOrDefault(currentStyle));
    }

    public StyleSelectItemViewModel fromOOBibStyle(OOBibStyle style) {
        return new StyleSelectItemViewModel(style.getName(), String.join((CharSequence)", ", style.getJournals()), style.isInternalStyle() ? Localization.lang("Internal style", new Object[0]) : style.getPath(), style);
    }

    public OOBibStyle toOOBibStyle(StyleSelectItemViewModel item) {
        return item.getStyle();
    }

    public void addStyleFile() {
        FileDialogConfiguration fileDialogConfiguration = new FileDialogConfiguration.Builder().addExtensionFilter(Localization.lang("Style file", new Object[0]), (FileType)StandardFileType.JSTYLE).withDefaultExtension(Localization.lang("Style file", new Object[0]), StandardFileType.JSTYLE).withInitialDirectory(this.filePreferences.getWorkingDirectory()).build();
        Optional<Path> path = this.dialogService.showFileOpenDialog(fileDialogConfiguration);
        path.map(Path::toAbsolutePath).map(Path::toString).ifPresent(stylePath -> {
            if (this.styleLoader.addStyleIfValid((String)stylePath)) {
                this.openOfficePreferences.setCurrentStyle((String)stylePath);
                this.styles.setAll(this.loadStyles());
                this.selectedItem.setValue((Object)this.getStyleOrDefault((String)stylePath));
            } else {
                this.dialogService.showErrorDialogAndWait(Localization.lang("Invalid style selected", new Object[0]), Localization.lang("You must select a valid style file. Your style is probably missing a line for the type \"default\".", new Object[0]));
            }
        });
    }

    public List<StyleSelectItemViewModel> loadStyles() {
        return this.styleLoader.getStyles().stream().map(this::fromOOBibStyle).collect(Collectors.toList());
    }

    public ListProperty<StyleSelectItemViewModel> stylesProperty() {
        return this.styles;
    }

    public void deleteStyle() {
        OOBibStyle style = ((StyleSelectItemViewModel)this.selectedItem.getValue()).getStyle();
        if (this.styleLoader.removeStyle(style)) {
            this.styles.remove(this.selectedItem.get());
        }
    }

    public void editStyle() {
        OOBibStyle style = ((StyleSelectItemViewModel)this.selectedItem.getValue()).getStyle();
        Optional<ExternalFileType> type = ExternalFileTypes.getExternalFileTypeByExt("jstyle", this.filePreferences);
        try {
            JabRefDesktop.openExternalFileAnyFormat(new BibDatabaseContext(), this.filePreferences, style.getPath(), type);
        }
        catch (IOException e) {
            this.dialogService.showErrorDialogAndWait(e);
        }
    }

    public void viewStyle(StyleSelectItemViewModel item) {
        DialogPane pane = new DialogPane();
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setFitToHeight(true);
        scrollPane.setFitToWidth(true);
        TextArea styleView = new TextArea(item.getStyle().getLocalCopy());
        scrollPane.setContent((Node)styleView);
        pane.setContent((Node)scrollPane);
        this.dialogService.showCustomDialogAndWait(item.getStyle().getName(), pane, ButtonType.OK);
    }

    public ObjectProperty<StyleSelectItemViewModel> selectedItemProperty() {
        return this.selectedItem;
    }

    public void storePrefs() {
        List<String> externalStyles = this.styles.stream().map(this::toOOBibStyle).filter(style -> !style.isInternalStyle()).map(OOBibStyle::getPath).collect(Collectors.toList());
        this.openOfficePreferences.setExternalStyles(externalStyles);
        this.openOfficePreferences.setCurrentStyle(((StyleSelectItemViewModel)this.selectedItem.getValue()).getStylePath());
    }

    private StyleSelectItemViewModel getStyleOrDefault(String stylePath) {
        return this.styles.stream().filter(style -> style.getStylePath().equals(stylePath)).findFirst().orElse((StyleSelectItemViewModel)this.styles.getFirst());
    }
}

