/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.openoffice;

import com.airhacks.afterburner.views.ViewLoader;
import jakarta.inject.Inject;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.layout.FlowPane;
import javafx.scene.text.Text;
import org.jabref.gui.DialogService;
import org.jabref.gui.openoffice.CitationEntryViewModel;
import org.jabref.gui.openoffice.ManageCitationsDialogViewModel;
import org.jabref.gui.openoffice.OOBibBase;
import org.jabref.gui.util.BaseDialog;
import org.jabref.gui.util.ValueTableCellFactory;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.strings.StringUtil;

public class ManageCitationsDialogView
extends BaseDialog<Void> {
    private static final String HTML_BOLD_END_TAG = "</b>";
    private static final String HTML_BOLD_START_TAG = "<b>";
    private final OOBibBase ooBase;
    @FXML
    private TableView<CitationEntryViewModel> citationsTableView;
    @FXML
    private TableColumn<CitationEntryViewModel, String> citation;
    @FXML
    private TableColumn<CitationEntryViewModel, String> extraInfo;
    @Inject
    private DialogService dialogService;
    private ManageCitationsDialogViewModel viewModel;

    public ManageCitationsDialogView(OOBibBase ooBase) {
        this.ooBase = ooBase;
        ViewLoader.view((Object)((Object)this)).load().setAsDialogPane((Dialog)this);
        this.setResultConverter(btn -> {
            if (btn == ButtonType.OK) {
                this.viewModel.storeSettings();
            }
            return null;
        });
        this.setTitle(Localization.lang("Manage citations", new Object[0]));
    }

    @FXML
    private void initialize() {
        this.viewModel = new ManageCitationsDialogViewModel(this.ooBase, this.dialogService);
        this.citation.setCellValueFactory(cellData -> ((CitationEntryViewModel)cellData.getValue()).citationProperty());
        new ValueTableCellFactory().withGraphic(this::getText).install(this.citation);
        this.extraInfo.setCellValueFactory(cellData -> ((CitationEntryViewModel)cellData.getValue()).extraInformationProperty());
        this.extraInfo.setEditable(true);
        this.citationsTableView.setEditable(true);
        this.citationsTableView.itemsProperty().bindBidirectional(this.viewModel.citationsProperty());
        this.extraInfo.setOnEditCommit(cell -> ((CitationEntryViewModel)cell.getRowValue()).setExtraInfo((String)cell.getNewValue()));
        this.extraInfo.setCellFactory(TextFieldTableCell.forTableColumn());
    }

    private Node getText(String citationContext) {
        String inBetween = StringUtil.substringBetween(citationContext, HTML_BOLD_START_TAG, HTML_BOLD_END_TAG);
        String start = citationContext.substring(0, citationContext.indexOf(HTML_BOLD_START_TAG));
        String end = citationContext.substring(citationContext.lastIndexOf(HTML_BOLD_END_TAG) + HTML_BOLD_END_TAG.length());
        Text startText = new Text(start);
        Text inBetweenText = new Text(inBetween);
        inBetweenText.setStyle("-fx-font-weight: bold");
        Text endText = new Text(end);
        return new FlowPane(new Node[]{startText, inBetweenText, endText});
    }

    public boolean isOkToShowThisDialog() {
        return this.viewModel != null && !this.viewModel.failedToGetCitationEntries;
    }
}

