/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.openoffice;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import org.jabref.gui.DialogService;
import org.jabref.gui.desktop.JabRefDesktop;
import org.jabref.gui.util.DirectoryDialogConfiguration;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.openoffice.OpenOfficePreferences;
import org.jabref.logic.util.OS;
import org.jabref.logic.util.io.FileUtil;
import org.jabref.model.strings.StringUtil;

public class DetectOpenOfficeInstallation {
    private final OpenOfficePreferences openOfficePreferences;
    private final DialogService dialogService;

    public DetectOpenOfficeInstallation(OpenOfficePreferences openOfficePreferences, DialogService dialogService) {
        this.dialogService = dialogService;
        this.openOfficePreferences = openOfficePreferences;
    }

    public boolean isExecutablePathDefined() {
        return this.checkAutoDetectedPaths(this.openOfficePreferences);
    }

    public Optional<Path> selectInstallationPath() {
        this.dialogService.showInformationDialogAndWait(Localization.lang("Could not find OpenOffice/LibreOffice installation", new Object[0]), Localization.lang("Unable to autodetect OpenOffice/LibreOffice installation. Please choose the installation directory manually.", new Object[0]));
        DirectoryDialogConfiguration dirDialogConfiguration = new DirectoryDialogConfiguration.Builder().withInitialDirectory(JabRefDesktop.getApplicationDirectory()).build();
        return this.dialogService.showDirectorySelectionDialog(dirDialogConfiguration);
    }

    private boolean checkAutoDetectedPaths(OpenOfficePreferences openOfficePreferences) {
        String executablePath = openOfficePreferences.getExecutablePath();
        if (OS.LINUX && System.getenv("FLATPAK_SANDBOX_DIR") != null) {
            executablePath = "/app/bin/soffice";
        }
        return !StringUtil.isNullOrEmpty(executablePath) && Files.isRegularFile(Path.of(executablePath, new String[0]), new LinkOption[0]);
    }

    public boolean setOpenOfficePreferences(Path installDir) {
        Optional<Object> execPath = Optional.empty();
        if (OS.WINDOWS) {
            execPath = FileUtil.find("soffice.exe", installDir);
        } else if (OS.OS_X) {
            execPath = FileUtil.find("soffice", installDir);
        } else if (OS.LINUX) {
            execPath = FileUtil.find("soffice", installDir);
        }
        if (execPath.isPresent()) {
            this.openOfficePreferences.setExecutablePath(((Path)execPath.get()).toString());
            return true;
        }
        return false;
    }

    public Optional<Path> chooseAmongInstallations(List<Path> installDirs) {
        if (installDirs.isEmpty()) {
            return Optional.empty();
        }
        if (installDirs.size() == 1) {
            return Optional.of(installDirs.getFirst().toAbsolutePath());
        }
        return this.dialogService.showChoiceDialogAndWait(Localization.lang("Choose OpenOffice/LibreOffice executable", new Object[0]), Localization.lang("Found more than one OpenOffice/LibreOffice executable.", new Object[0]) + "\n" + Localization.lang("Please choose which one to connect to:", new Object[0]), Localization.lang("Use selected instance", new Object[0]), installDirs);
    }
}

